/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c;

import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.impl.SizeOfSupport;
import org.graalvm.word.PointerBase;

public final class SizeOfSupportImpl
implements SizeOfSupport {
    private final NativeLibraries nativeLibraries;

    public SizeOfSupportImpl(NativeLibraries nativeLibraries) {
        this.nativeLibraries = nativeLibraries;
    }

    public int sizeof(Class<? extends PointerBase> clazz) {
        ResolvedJavaType type = this.nativeLibraries.getMetaAccess().lookupJavaType(clazz);
        ElementInfo typeInfo = this.nativeLibraries.findElementInfo((AnnotatedElement)type);
        if (typeInfo instanceof StructInfo && ((StructInfo)typeInfo).isIncomplete()) {
            throw UserError.abort("Class parameter %s of call to %s is an incomplete structure, so no size is available", type.toJavaName(true), SizeOf.class.getSimpleName());
        }
        if (typeInfo instanceof SizableInfo) {
            return ((SizableInfo)typeInfo).getSizeInBytes();
        }
        throw UserError.abort("Class parameter %s of call to %s is not an annotated C interface type", type.toJavaName(true), SizeOf.class.getSimpleName());
    }
}

