/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.libc;

import com.oracle.svm.core.c.libc.MuslLibC;
import com.oracle.svm.hosted.c.libc.HostedLibCBase;
import com.oracle.svm.hosted.image.AbstractImage;
import java.util.Collections;
import java.util.List;

public class HostedMuslLibC
extends MuslLibC
implements HostedLibCBase {
    @Override
    public List<String> getAdditionalQueryCodeCompilerOptions() {
        return HostedMuslLibC.isCrossCompiling() ? Collections.singletonList("--static") : Collections.emptyList();
    }

    @Override
    public String getTargetCompiler() {
        return HostedMuslLibC.isCrossCompiling() ? "x86_64-linux-musl-gcc" : "gcc";
    }

    @Override
    public boolean requiresLibCSpecificStaticJDKLibraries() {
        return HostedMuslLibC.isCrossCompiling();
    }

    @Override
    public List<String> getAdditionalLinkerOptions(AbstractImage.NativeImageKind imageKind) {
        if (imageKind != AbstractImage.NativeImageKind.EXECUTABLE) {
            return List.of();
        }
        return List.of("-no-pie");
    }

    private static boolean isCrossCompiling() {
        return !"musl".equals(System.getProperty("substratevm.HostLibC"));
    }
}

