/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code.amd64;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.code.CGlobalDataReference;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.HostedPatcher;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedMethod;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.code.CompilationResult;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.VMConstant;

class AMD64HostedPatcher
extends CompilationResult.CodeAnnotation
implements HostedPatcher {
    private final AMD64BaseAssembler.OperandDataAnnotation annotation;

    AMD64HostedPatcher(AMD64BaseAssembler.OperandDataAnnotation annotation) {
        super(annotation.instructionPosition);
        this.annotation = annotation;
    }

    @Override
    @Uninterruptible(reason=".")
    public void patch(int compStart, int relative, byte[] code) {
        int curValue = relative - (this.annotation.nextInstructionPosition - this.annotation.instructionPosition);
        for (int i = 0; i < this.annotation.operandSize; ++i) {
            assert (code[this.annotation.operandPosition + i] == 0);
            code[this.annotation.operandPosition + i] = (byte)(curValue & 0xFF);
            curValue >>>= 8;
        }
        assert (curValue == 0);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public void relocate(Reference ref, RelocatableBuffer relocs, int compStart) {
        long siteOffset = compStart + this.annotation.operandPosition;
        if (ref instanceof DataSectionReference || ref instanceof CGlobalDataReference) {
            long addend = this.annotation.nextInstructionPosition - this.annotation.operandPosition;
            assert (addend == (long)this.annotation.operandSize);
            relocs.addRelocationWithAddend((int)siteOffset, ObjectFile.RelocationKind.getPCRelative((int)this.annotation.operandSize), addend, ref);
        } else if (ref instanceof ConstantReference) {
            ConstantReference constantReference = (ConstantReference)ref;
            VMConstant constant = constantReference.getConstant();
            if (constant instanceof SubstrateMethodPointerConstant) {
                SubstrateMethodPointerConstant methodPointerConstant = (SubstrateMethodPointerConstant)constant;
                MethodPointer pointer = methodPointerConstant.pointer();
                HostedMethod hMethod = (HostedMethod)pointer.getMethod();
                VMError.guarantee(!hMethod.isCompiledInPriorLayer(), "Method %s was compiled in a prior layer", hMethod);
                VMError.guarantee(hMethod.isCompiled(), "Method %s is not compiled although there is a method pointer constant created for it.", hMethod);
                ObjectFile.RelocationKind kindPCRelative = ObjectFile.RelocationKind.getPCRelative((int)this.annotation.operandSize);
                long addend = -ObjectFile.RelocationKind.getRelocationSize((ObjectFile.RelocationKind)kindPCRelative);
                relocs.addRelocationWithAddend((int)siteOffset, kindPCRelative, addend, pointer);
            } else {
                ObjectFile.RelocationKind kindDirect = ObjectFile.RelocationKind.getDirect((int)this.annotation.operandSize);
                relocs.addRelocationWithoutAddend((int)siteOffset, kindDirect, constantReference);
            }
        } else {
            throw VMError.shouldNotReachHere("Unknown type of reference in code");
        }
    }
}

