/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.hosted.ImageClassLoader;
import java.util.List;
import org.graalvm.collections.UnmodifiableEconomicMap;

class ImageSingletonLoaderImpl
implements ImageSingletonLoader {
    private final UnmodifiableEconomicMap<String, Object> keyStore;
    private final ImageClassLoader imageClassLoader;

    ImageSingletonLoaderImpl(UnmodifiableEconomicMap<String, Object> keyStore, ImageClassLoader imageClassLoader) {
        this.keyStore = keyStore;
        this.imageClassLoader = imageClassLoader;
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    @Override
    public List<Boolean> readBoolList(String keyName) {
        List value = (List)ImageSingletonLoaderImpl.cast(this.keyStore.get((Object)keyName));
        String type = (String)ImageSingletonLoaderImpl.cast(value.get(0));
        assert (type.equals("B(")) : type;
        List internalValue = (List)ImageSingletonLoaderImpl.cast(value.get(1));
        return internalValue.stream().map(e -> e == 1).toList();
    }

    @Override
    public int readInt(String keyName) {
        List value = (List)ImageSingletonLoaderImpl.cast(this.keyStore.get((Object)keyName));
        String type = (String)ImageSingletonLoaderImpl.cast(value.get(0));
        assert (type.equals("I")) : type;
        return (Integer)ImageSingletonLoaderImpl.cast(value.get(1));
    }

    @Override
    public List<Integer> readIntList(String keyName) {
        List value = (List)ImageSingletonLoaderImpl.cast(this.keyStore.get((Object)keyName));
        String type = (String)ImageSingletonLoaderImpl.cast(value.get(0));
        assert (type.equals("I(")) : type;
        return (List)ImageSingletonLoaderImpl.cast(value.get(1));
    }

    @Override
    public long readLong(String keyName) {
        List value = (List)ImageSingletonLoaderImpl.cast(this.keyStore.get((Object)keyName));
        String type = (String)ImageSingletonLoaderImpl.cast(value.get(0));
        assert (type.equals("L")) : type;
        Number number = (Number)ImageSingletonLoaderImpl.cast(value.get(1));
        return number.longValue();
    }

    @Override
    public String readString(String keyName) {
        List value = (List)ImageSingletonLoaderImpl.cast(this.keyStore.get((Object)keyName));
        String type = (String)ImageSingletonLoaderImpl.cast(value.get(0));
        assert (type.equals("S")) : type;
        return (String)ImageSingletonLoaderImpl.cast(value.get(1));
    }

    @Override
    public List<String> readStringList(String keyName) {
        List value = (List)ImageSingletonLoaderImpl.cast(this.keyStore.get((Object)keyName));
        String type = (String)ImageSingletonLoaderImpl.cast(value.get(0));
        assert (type.equals("S(")) : type;
        return (List)ImageSingletonLoaderImpl.cast(value.get(1));
    }

    @Override
    public Class<?> lookupClass(String className) {
        return this.imageClassLoader.findClass(className).get();
    }
}

