/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.OpenTypeWorldFeature;
import com.oracle.svm.hosted.heap.SVMImageLayerLoader;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.LayeredDispatchTableSupport;
import java.util.Map;
import java.util.Set;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class LayeredDispatchTableSupportFeature
implements InternalFeature {
    LayeredDispatchTableSupportFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ImageLayerBuildingSupport.buildingImageLayer();
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        if (ImageLayerBuildingSupport.buildingInitialLayer()) {
            ImageSingletons.add(LayeredDispatchTableSupport.class, (Object)new LayeredDispatchTableSupport());
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (ImageLayerBuildingSupport.buildingExtensionLayer()) {
            FeatureImpl.BeforeAnalysisAccessImpl config = (FeatureImpl.BeforeAnalysisAccessImpl)access;
            SVMImageLayerLoader loader = HostedImageLayerBuildingSupport.singleton().getLoader();
            LayeredDispatchTableSupport singleton = LayeredDispatchTableSupport.singleton();
            for (Map.Entry<Integer, Set<String>> entry : singleton.priorVirtualCallTargets.entrySet()) {
                AnalysisType type = loader.getAnalysisType(entry.getKey());
                Set methods = type.getOrCalculateOpenTypeWorldDispatchTableMethods();
                Set<String> virtualCallTargets = entry.getValue();
                methods.forEach(aMethod -> {
                    if (virtualCallTargets.contains(LayeredDispatchTableSupport.generateFormattedMethodName(aMethod))) {
                        config.registerAsRoot((AnalysisMethod)aMethod, false, "in prior layer dispatch table", new MultiMethod.MultiMethodKey[0]);
                    }
                });
            }
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        LayeredDispatchTableSupport.singleton().installBuilderModules(((OpenTypeWorldFeature)ImageSingletons.lookup(OpenTypeWorldFeature.class)).getBuilderModules());
    }
}

