/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public final class InjectedAccessorsPlugin
implements NodePlugin {
    public boolean handleLoadField(GraphBuilderContext b, ValueNode object, ResolvedJavaField field) {
        return InjectedAccessorsPlugin.handleField(b, (AnalysisField)field, false, object, true, null);
    }

    public boolean handleLoadStaticField(GraphBuilderContext b, ResolvedJavaField field) {
        return InjectedAccessorsPlugin.handleField(b, (AnalysisField)field, true, null, true, null);
    }

    public boolean handleStoreField(GraphBuilderContext b, ValueNode object, ResolvedJavaField field, ValueNode value) {
        return InjectedAccessorsPlugin.handleField(b, (AnalysisField)field, false, object, false, value);
    }

    public boolean handleStoreStaticField(GraphBuilderContext b, ResolvedJavaField field, ValueNode value) {
        return InjectedAccessorsPlugin.handleField(b, (AnalysisField)field, true, null, false, value);
    }

    private static boolean handleField(GraphBuilderContext b, AnalysisField field, boolean isStatic, ValueNode receiver, boolean isGet, ValueNode value) {
        InjectAccessors injectAccesors = (InjectAccessors)field.getAnnotation(InjectAccessors.class);
        if (injectAccesors == null) {
            return false;
        }
        AnalysisMetaAccess metaAccess = (AnalysisMetaAccess)b.getMetaAccess();
        Class accessorsClass = injectAccesors.value();
        AnalysisType accessorsType = metaAccess.lookupJavaType(accessorsClass);
        String shortName = isGet ? "get" : "set";
        String fieldName = field.getName();
        String longName = shortName + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        AnalysisMethod foundMethod = null;
        for (AnalysisMethod method : accessorsType.getDeclaredMethods(false)) {
            if (!method.getName().equals(shortName) && !method.getName().equals(longName)) continue;
            if (foundMethod != null) {
                InjectedAccessorsPlugin.error(field, accessorsType, null, "found two methods " + foundMethod.format("%n(%p)") + " and " + method.format("%n(%p)"));
            }
            foundMethod = method;
        }
        if (foundMethod == null) {
            InjectedAccessorsPlugin.error(field, accessorsType, null, "found no method named " + shortName + " or " + longName);
        }
        if (!foundMethod.isStatic()) {
            InjectedAccessorsPlugin.error(field, accessorsType, foundMethod, "method is not static");
        }
        int paramIdx = 0;
        if (!isStatic) {
            if (foundMethod.getSignature().getParameterCount(false) < paramIdx + 1) {
                InjectedAccessorsPlugin.error(field, accessorsType, foundMethod, "not enough parameters");
            }
            AnalysisType actualReceiver = (AnalysisType)foundMethod.getSignature().getParameterType(paramIdx);
            AnalysisType expectedReceiver = field.getDeclaringClass();
            boolean match = false;
            for (AnalysisType cur = expectedReceiver; cur != null; cur = cur.getSuperclass()) {
                if (!actualReceiver.equals((Object)cur)) continue;
                match = true;
                break;
            }
            if (!match) {
                InjectedAccessorsPlugin.error(field, accessorsType, foundMethod, "wrong receiver type: expected " + expectedReceiver.toJavaName(true) + " or a superclass, found " + actualReceiver.toJavaName(true));
            }
            ++paramIdx;
        }
        AnalysisType expectedValue = field.getType();
        if (isGet) {
            actualValue = (AnalysisType)foundMethod.getSignature().getReturnType();
            if (!actualValue.equals((Object)expectedValue)) {
                InjectedAccessorsPlugin.error(field, accessorsType, foundMethod, "wrong return type: expected " + expectedValue.toJavaName(true) + ", found " + actualValue.toJavaName(true));
            }
        } else {
            if (foundMethod.getSignature().getParameterCount(false) < paramIdx + 1) {
                InjectedAccessorsPlugin.error(field, accessorsType, foundMethod, "not enough parameters");
            }
            if (!(actualValue = (AnalysisType)foundMethod.getSignature().getParameterType(paramIdx)).equals((Object)expectedValue)) {
                InjectedAccessorsPlugin.error(field, accessorsType, foundMethod, "wrong value type: expected " + expectedValue.toJavaName(true) + ", found " + actualValue.toJavaName(true));
            }
            ++paramIdx;
        }
        if (foundMethod.getSignature().getParameterCount(false) != paramIdx) {
            InjectedAccessorsPlugin.error(field, accessorsType, foundMethod, "Wrong number of parameters: expected " + paramIdx + ", found " + foundMethod.getSignature().getParameterCount(false));
        }
        ArrayList<ValueNode> args = new ArrayList<ValueNode>();
        if (!isStatic) {
            args.add(receiver);
        }
        if (!isGet) {
            args.add(value);
        }
        b.handleReplacedInvoke(CallTargetNode.InvokeKind.Static, (ResolvedJavaMethod)foundMethod, args.toArray(new ValueNode[args.size()]), false);
        return true;
    }

    private static void error(AnalysisField field, AnalysisType accessorsType, AnalysisMethod method, String msg) {
        throw VMError.shouldNotReachHere("Error in @" + InjectAccessors.class.getSimpleName() + " handling of field " + field.format("%H.%n") + ", accessors class " + accessorsType.toJavaName(true) + (String)(method == null ? "" : ", method " + method.format("%n(%p)")) + ": " + msg);
    }
}

