/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.svm.hosted.annotation.AnnotationWrapper;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class AliasField
implements ResolvedJavaField,
OriginalFieldProvider,
AnnotationWrapper {
    final ResolvedJavaField original;
    final ResolvedJavaField annotated;
    final boolean isFinal;

    AliasField(ResolvedJavaField original, ResolvedJavaField annotated, boolean isFinal) {
        this.original = original;
        this.annotated = annotated;
        this.isFinal = isFinal;
    }

    public String getName() {
        return this.original.getName();
    }

    public JavaType getType() {
        return this.original.getType();
    }

    public int getModifiers() {
        int result = this.original.getModifiers();
        result = this.isFinal ? (result |= 0x10) : (result &= 0xFFFFFFEF);
        return result;
    }

    public int getOffset() {
        return this.original.getOffset();
    }

    public boolean isInternal() {
        return this.original.isInternal();
    }

    public boolean isSynthetic() {
        return this.original.isSynthetic();
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.original.getDeclaringClass();
    }

    @Override
    public AnnotatedElement getAnnotationRoot() {
        return this.original;
    }

    public String toString() {
        return "AliasField<original " + this.original.toString() + ">";
    }

    public ResolvedJavaField unwrapTowardsOriginalField() {
        return this.original;
    }

    public JavaConstant getConstantValue() {
        return this.original.getConstantValue();
    }
}

