/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.thread;

import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.threadlocal.FastThreadLocal;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.thread.VMThreadLocalCollector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jdk.graal.compiler.debug.Assertions;

public class LayeredVMThreadLocalCollector
extends VMThreadLocalCollector
implements LayeredImageSingleton {
    final Map<String, ThreadInfo> threadLocalAssignmentMap;
    private final boolean initialLayer;
    private int nextOffset;

    public LayeredVMThreadLocalCollector() {
        this(null, -1);
    }

    private LayeredVMThreadLocalCollector(Map<String, ThreadInfo> threadLocalAssignmentMap, int nextOffset) {
        super(true);
        this.threadLocalAssignmentMap = threadLocalAssignmentMap;
        this.initialLayer = ImageLayerBuildingSupport.buildingInitialLayer();
        this.nextOffset = nextOffset;
    }

    @Override
    public Object apply(Object source) {
        if (!this.initialLayer && source instanceof FastThreadLocal) {
            FastThreadLocal threadLocal = (FastThreadLocal)source;
            String name = threadLocal.getName();
            VMError.guarantee(this.threadLocalAssignmentMap.containsKey(name), "Found thread local which was not created in the initial layer %s", name);
        }
        return super.apply(source);
    }

    @Override
    public int sortAndAssignOffsets() {
        if (this.initialLayer) {
            assert (this.nextOffset == -1) : this.nextOffset;
            this.nextOffset = super.sortAndAssignOffsets();
        } else {
            assert (this.nextOffset != -1);
            for (VMThreadLocalInfo info : this.threadLocals.values()) {
                ThreadInfo assignment = this.threadLocalAssignmentMap.get(info.name);
                info.offset = assignment.offset();
                assert (assignment.size() == LayeredVMThreadLocalCollector.calculateSize(info)) : Assertions.errorMessage((Object[])new Object[]{"Mismatch in computed size: ", assignment.size(), LayeredVMThreadLocalCollector.calculateSize(info), info.name});
                info.sizeInBytes = assignment.size();
            }
        }
        return this.nextOffset;
    }

    @Override
    public int getOffset(FastThreadLocal threadLocal) {
        if (this.initialLayer) {
            return super.getOffset(threadLocal);
        }
        return this.threadLocalAssignmentMap.get(threadLocal.getName()).offset();
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        ArrayList<String> threadLocalNames = new ArrayList<String>();
        ArrayList<Integer> threadLocalOffsets = new ArrayList<Integer>();
        ArrayList<Integer> threadLocalSizes = new ArrayList<Integer>();
        if (this.initialLayer) {
            for (VMThreadLocalInfo threadLocal : this.getSortedThreadLocalInfos()) {
                threadLocalNames.add(threadLocal.name);
                threadLocalOffsets.add(threadLocal.offset);
                threadLocalSizes.add(threadLocal.sizeInBytes);
            }
        } else {
            for (Map.Entry<String, ThreadInfo> entry : this.threadLocalAssignmentMap.entrySet()) {
                threadLocalNames.add(entry.getKey());
                threadLocalOffsets.add(entry.getValue().offset());
                threadLocalSizes.add(entry.getValue().size());
            }
        }
        writer.writeStringList("threadLocalNames", threadLocalNames);
        writer.writeIntList("threadLocalOffsets", threadLocalOffsets);
        writer.writeIntList("threadLocalSizes", threadLocalSizes);
        writer.writeInt("nextOffset", this.nextOffset);
        return LayeredImageSingleton.PersistFlags.CREATE;
    }

    public static Object createFromLoader(ImageSingletonLoader loader) {
        HashMap<String, ThreadInfo> threadLocalAssignmentMap = new HashMap<String, ThreadInfo>();
        Iterator<String> threadLocalNames = loader.readStringList("threadLocalNames").iterator();
        Iterator<Integer> threadLocalOffsets = loader.readIntList("threadLocalOffsets").iterator();
        Iterator<Integer> threadLocalSizes = loader.readIntList("threadLocalSizes").iterator();
        while (threadLocalNames.hasNext()) {
            String threadLocalName = threadLocalNames.next();
            int threadLocalOffset = threadLocalOffsets.next();
            int threadLocalSize = threadLocalSizes.next();
            ThreadInfo previous = threadLocalAssignmentMap.put(threadLocalName, new ThreadInfo(threadLocalSize, threadLocalOffset));
            assert (previous == null) : previous;
        }
        return new LayeredVMThreadLocalCollector(Map.copyOf(threadLocalAssignmentMap), loader.readInt("nextOffset"));
    }

    record ThreadInfo(int size, int offset) {
    }
}

