/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.collections;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.collections.UninterruptibleComparable;
import com.oracle.svm.core.util.BasedOnJDKClass;
import com.oracle.svm.core.util.VMError;
import java.util.PriorityQueue;

@BasedOnJDKClass(value=PriorityQueue.class)
public class UninterruptiblePriorityQueue {
    private final UninterruptibleComparable[] queue;
    private int size;

    public UninterruptiblePriorityQueue(UninterruptibleComparable[] queue) {
        this.queue = queue;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isFull() {
        return this.size == this.queue.length;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean add(UninterruptibleComparable e) {
        return this.offer(e);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean offer(UninterruptibleComparable e) {
        assert (e != null);
        int i = this.size;
        if (i >= this.queue.length) {
            throw VMError.shouldNotReachHere("offer() must not be called without checking capacity.");
        }
        UninterruptiblePriorityQueue.siftUp(i, e, this.queue);
        this.size = i + 1;
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UninterruptibleComparable poll() {
        UninterruptibleComparable[] es = this.queue;
        UninterruptibleComparable result = this.queue[0];
        if (result != null) {
            int n = --this.size;
            UninterruptibleComparable x = es[this.size];
            es[n] = null;
            if (n > 0) {
                UninterruptiblePriorityQueue.siftDown(0, x, es, n);
            }
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UninterruptibleComparable peek() {
        return this.queue[0];
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean remove(UninterruptibleComparable o) {
        int i = this.indexOf(o);
        if (i == -1) {
            return false;
        }
        this.removeAt(i);
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private UninterruptibleComparable removeAt(int i) {
        int s;
        UninterruptibleComparable[] es = this.queue;
        if ((s = --this.size) == i) {
            es[i] = null;
        } else {
            UninterruptibleComparable moved = es[s];
            es[s] = null;
            UninterruptiblePriorityQueue.siftDown(i, moved, es, this.size);
            if (es[i] == moved) {
                UninterruptiblePriorityQueue.siftUp(i, moved, es);
                if (es[i] != moved) {
                    return moved;
                }
            }
        }
        return null;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private int indexOf(UninterruptibleComparable o) {
        if (o != null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (o != this.queue[i]) continue;
                return i;
            }
        }
        return -1;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void siftUp(int k, UninterruptibleComparable x, UninterruptibleComparable[] es) {
        int parent;
        UninterruptibleComparable e;
        while (k > 0 && x.compareTo(e = es[parent = k - 1 >>> 1]) < 0) {
            es[k] = e;
            k = parent;
        }
        es[k] = x;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void siftDown(int k, UninterruptibleComparable x, UninterruptibleComparable[] es, int n) {
        int half = n >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            UninterruptibleComparable c = es[child];
            int right = child + 1;
            if (right < n && c.compareTo(es[right]) > 0) {
                child = right;
                c = es[child];
            }
            if (x.compareTo(c) <= 0) break;
            es[k] = c;
            k = child;
        }
        es[k] = x;
    }
}

