/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.riscv64;

import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.code.SubstrateRegisterConfigFactory;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.graal.riscv64.RISCV64ReservedRegisters;
import com.oracle.svm.core.graal.riscv64.SubstrateRISCV64RegisterConfig;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={Platform.RISCV64.class})
class SubstrateRISCV64Feature
implements InternalFeature {
    SubstrateRISCV64Feature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(SubstrateRegisterConfigFactory.class, (Object)new SubstrateRegisterConfigFactory(this){

            @Override
            public RegisterConfig newRegisterFactory(SubstrateRegisterConfig.ConfigKind config, MetaAccessProvider metaAccess, TargetDescription target, Boolean preserveFramePointer) {
                return new SubstrateRISCV64RegisterConfig(config, metaAccess, target, preserveFramePointer);
            }
        });
        ImageSingletons.add(ReservedRegisters.class, (Object)new RISCV64ReservedRegisters());
        if (!SubstrateOptions.useLLVMBackend()) {
            throw GraalError.unimplemented((String)"The RISC-V native backend is currently unimplemented. Use the LLVM backend.");
        }
    }
}

