/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.stackvalue;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.stackvalue.AbstractStackValueNode;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.ResolvedJavaMethod;

@NodeInfo(cycles=NodeCycles.CYCLES_4, size=NodeSize.SIZE_8)
public class LateStackValueNode
extends AbstractStackValueNode {
    public static final NodeClass<LateStackValueNode> TYPE = NodeClass.create(LateStackValueNode.class);
    @Node.Input
    protected ValueNode sizeInBytes;

    protected LateStackValueNode(ValueNode sizeInBytes, int alignmentInBytes, StackValueNode.StackSlotIdentity slotIdentity, boolean checkVirtualThread) {
        super(TYPE, alignmentInBytes, slotIdentity, checkVirtualThread);
        this.sizeInBytes = sizeInBytes;
    }

    public static LateStackValueNode create(ValueNode sizeInBytes, ResolvedJavaMethod method, int bci, boolean disallowVirtualThread) {
        int alignmentInBytes = ConfigurationValues.getTarget().stackAlignment;
        StackValueNode.StackSlotIdentity slotIdentity = LateStackValueNode.createStackSlotIdentity(method, bci);
        return new LateStackValueNode(sizeInBytes, alignmentInBytes, slotIdentity, LateStackValueNode.needsVirtualThreadCheck(method, disallowVirtualThread));
    }
}

