/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import jdk.graal.compiler.api.replacements.Fold;

public class RuntimeClassLoadingSupport {
    public static final String ENABLE_CLASS_LOADING_OPTION = SubstrateOptionsParser.commandArgument(Options.SupportRuntimeClassLoading, "+");

    @Fold
    public static boolean supportsRuntimeClassLoading() {
        return Options.SupportRuntimeClassLoading.getValue();
    }

    public static final class Options {
        public static final HostedOptionKey<Boolean> SupportRuntimeClassLoading = new HostedOptionKey<Boolean>(false, Options::validate);

        private static void validate(HostedOptionKey<Boolean> optionKey) {
            if (optionKey.hasBeenSet() && optionKey.getValue().booleanValue() && SubstrateOptions.ClosedTypeWorld.getValue().booleanValue()) {
                throw UserError.invalidOptionValue(SupportRuntimeClassLoading, SupportRuntimeClassLoading.getValue(), "Requires an open type world, Please use " + SubstrateOptionsParser.commandArgument(SubstrateOptions.ClosedTypeWorld, "-"));
            }
        }
    }
}

