/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.ForeignDisabled;
import com.oracle.svm.core.jdk.ForeignDisabledSubstitutions;
import com.oracle.svm.core.jdk.JDK21OrEarlier;
import com.oracle.svm.core.jdk.JDKLatest;
import com.oracle.svm.core.jdk.ModuleNative;
import com.oracle.svm.core.util.BasedOnJDKFile;

@TargetClass(value=Module.class)
public final class Target_java_lang_Module {
    @Alias
    @RecomputeFieldValue(isFinal=false, kind=RecomputeFieldValue.Kind.None)
    private ModuleLayer layer;

    @Substitute
    @TargetElement(onlyWith={ForeignDisabled.class})
    public boolean isNativeAccessEnabled() {
        throw ForeignDisabledSubstitutions.fail();
    }

    @Alias
    @TargetElement(onlyWith={JDK21OrEarlier.class})
    public native void ensureNativeAccess(Class<?> var1, String var2);

    @Alias
    @TargetElement(onlyWith={JDKLatest.class})
    public native void ensureNativeAccess(Class<?> var1, String var2, Class<?> var3, boolean var4);

    @Substitute
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+22/src/hotspot/share/classfile/modules.cpp#L279-L478")
    private static void defineModule0(Module module, boolean isOpen, String version, String location, Object[] pns) {
        ModuleNative.defineModule(module, isOpen, pns);
    }

    @Substitute
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+10/src/hotspot/share/classfile/modules.cpp#L763-L799")
    private static void addReads0(Module from, Module to) {
        ModuleNative.addReads(from, to);
    }

    @Substitute
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+10/src/hotspot/share/classfile/modules.cpp#L753-L761")
    private static void addExports0(Module from, String pn, Module to) {
        ModuleNative.addExports(from, pn, to);
    }

    @Substitute
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+10/src/hotspot/share/classfile/modules.cpp#L686-L750")
    private static void addExportsToAll0(Module from, String pn) {
        ModuleNative.addExportsToAll(from, pn);
    }

    @Substitute
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+10/src/hotspot/share/classfile/modules.cpp#L869-L918")
    private static void addExportsToAllUnnamed0(Module from, String pn) {
        ModuleNative.addExportsToAllUnnamed(from, pn);
    }
}

