/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.target;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.reflect.RuntimeMetadataDecoder;
import com.oracle.svm.core.reflect.target.EncodedRuntimeMetadataSupplier;
import com.oracle.svm.core.reflect.target.ReflectionMetadataComputer;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_AccessibleObject;
import com.oracle.svm.core.reflect.target.Target_java_lang_reflect_Executable_ParameterData;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Map;
import org.graalvm.nativeimage.ImageSingletons;

@TargetClass(value=Executable.class)
public final class Target_java_lang_reflect_Executable {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Target_java_lang_reflect_Executable_ParameterData parameterData;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Map<Class<? extends Annotation>, Annotation> declaredAnnotations;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=RawParametersComputer.class)
    byte[] rawParameters;

    @Substitute
    private Parameter[] getParameters0() {
        if (this.rawParameters == null) {
            return null;
        }
        Executable executable = SubstrateUtil.cast(this, Executable.class);
        DynamicHub declaringClass = DynamicHub.fromClass(executable.getDeclaringClass());
        return ((RuntimeMetadataDecoder)ImageSingletons.lookup(RuntimeMetadataDecoder.class)).parseReflectParameters(executable, this.rawParameters, declaringClass);
    }

    @Substitute
    byte[] getTypeAnnotationBytes0() {
        return SubstrateUtil.cast((Object)this, Target_java_lang_reflect_AccessibleObject.class).typeAnnotations;
    }

    static class RawParametersComputer
    extends ReflectionMetadataComputer {
        RawParametersComputer() {
        }

        public Object transform(Object receiver, Object originalValue) {
            return ((EncodedRuntimeMetadataSupplier)ImageSingletons.lookup(EncodedRuntimeMetadataSupplier.class)).getReflectParametersEncoding((Executable)receiver);
        }
    }
}

