/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationAccess;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_Continuation;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@InternalVMMethod
public final class ContinuationInternals {
    public static Pointer getBaseSP(Target_jdk_internal_vm_Continuation c) {
        return c.baseSP;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static StoredContinuation getStoredContinuation(Target_jdk_internal_vm_Continuation c) {
        return c.stored;
    }

    public static void setStoredContinuation(Target_jdk_internal_vm_Continuation cont, StoredContinuation instance) {
        cont.stored = instance;
    }

    @NeverInline(value="Needs a frame to return to when yielding.")
    static void enterSpecial0(Target_jdk_internal_vm_Continuation c, boolean isContinue) {
        ContinuationInternals.enterSpecial1(c, isContinue);
    }

    @NeverInline(value="Accesses caller stack pointer and return address.")
    private static Object enterSpecial1(Target_jdk_internal_vm_Continuation c, boolean isContinue) {
        Pointer callerSP = KnownIntrinsics.readCallerStackPointer();
        CodePointer callerIP = KnownIntrinsics.readReturnAddress();
        assert (c.sp.isNull() && c.ip.isNull() && c.baseSP.isNull());
        if (isContinue) {
            StoredContinuation stored = c.stored;
            assert (stored != null);
            c.ip = callerIP;
            c.sp = callerSP;
            c.baseSP = KnownIntrinsics.readStackPointer();
            c.stored = null;
            int framesSize = StoredContinuationAccess.getFramesSizeInBytes(stored);
            Pointer topSP = KnownIntrinsics.readStackPointer().subtract(framesSize);
            if (!StackOverflowCheck.singleton().isWithinBounds((UnsignedWord)topSP)) {
                throw ImplicitExceptions.CACHED_STACK_OVERFLOW_ERROR;
            }
            Object preparedData = ((ContinuationSupport)ImageSingletons.lookup(ContinuationSupport.class)).prepareCopy(stored);
            ContinuationSupport.enter(stored, topSP, preparedData);
            throw VMError.shouldNotReachHereAtRuntime();
        }
        assert (c.stored == null);
        c.ip = callerIP;
        c.sp = callerSP;
        c.baseSP = KnownIntrinsics.readStackPointer();
        ContinuationInternals.enterSpecial2(c);
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @NeverInline(value="Needs a separate frame which is part of the continuation stack that we can eventually return to.")
    private static void enterSpecial2(Target_jdk_internal_vm_Continuation c) {
        try {
            c.enter0();
        }
        catch (Throwable t) {
            throw VMError.shouldNotReachHere(t);
        }
        Pointer returnSP = c.sp;
        CodePointer returnIP = c.ip;
        c.ip = (CodePointer)WordFactory.nullPointer();
        c.sp = (Pointer)WordFactory.nullPointer();
        c.baseSP = (Pointer)WordFactory.nullPointer();
        assert (c.isEmpty());
        KnownIntrinsics.farReturn(null, returnSP, returnIP, false);
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @NeverInline(value="Needs a frame to resume the continuation at.")
    static Integer doYield0(Target_jdk_internal_vm_Continuation c) {
        return ContinuationInternals.doYield1(c);
    }

    @NeverInline(value="Accesses caller stack pointer and return address.")
    private static Integer doYield1(Target_jdk_internal_vm_Continuation c) {
        Pointer leafSP = KnownIntrinsics.readCallerStackPointer();
        CodePointer leafIP = KnownIntrinsics.readReturnAddress();
        Pointer returnSP = c.sp;
        CodePointer returnIP = c.ip;
        int preemptStatus = StoredContinuationAccess.allocateToYield(c, c.baseSP, leafSP, leafIP);
        if (preemptStatus != 0) {
            return preemptStatus;
        }
        c.ip = (CodePointer)WordFactory.nullPointer();
        c.sp = (Pointer)WordFactory.nullPointer();
        c.baseSP = (Pointer)WordFactory.nullPointer();
        KnownIntrinsics.farReturn(null, returnSP, returnIP, false);
        throw VMError.shouldNotReachHereAtRuntime();
    }
}

