/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.meta.DirectSubstrateObjectConstant;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.meta.SubstrateType;
import java.lang.annotation.Annotation;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateField
implements SharedField {
    protected static final SubstrateField[] EMPTY_ARRAY = new SubstrateField[0];
    @UnknownObjectField
    SubstrateType type;
    @UnknownObjectField
    SubstrateType declaringClass;
    private final String name;
    private final int modifiers;
    private int hashCode;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    int location;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private boolean isAccessed;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterCompilation.class)
    private boolean isWritten;
    @UnknownObjectField(types={DirectSubstrateObjectConstant.class, PrimitiveConstant.class}, fullyQualifiedTypes={"jdk.vm.ci.meta.NullConstant"}, canBeNull=true, availability=BuildPhaseProvider.AfterCompilation.class)
    JavaConstant constantValue;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateField(AnalysisField aField, HostedStringDeduplication stringTable) {
        VMError.guarantee(!aField.isInternal(), "Internal fields are not supported for JIT compilation");
        ResolvedJavaField oField = OriginalFieldProvider.getOriginalField((ResolvedJavaField)aField);
        boolean injectFinalForRuntimeCompilation = oField != null && oField.isFinal();
        this.modifiers = aField.getModifiers() | (injectFinalForRuntimeCompilation ? 16 : 0);
        this.name = stringTable.deduplicate(aField.getName(), true);
        this.hashCode = aField.hashCode();
    }

    public void setLinks(SubstrateType type, SubstrateType declaringClass) {
        this.type = type;
        this.declaringClass = declaringClass;
    }

    public void setSubstrateData(int location, boolean isAccessed, boolean isWritten, JavaConstant constantValue) {
        this.location = location;
        this.isAccessed = isAccessed;
        this.isWritten = isWritten;
        this.constantValue = constantValue;
    }

    @Override
    public int getLocation() {
        return this.location;
    }

    @Override
    public boolean isAccessed() {
        return this.isAccessed;
    }

    @Override
    public boolean isReachable() {
        return this.isAccessed || this.isWritten;
    }

    @Override
    public boolean isWritten() {
        return this.isWritten;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public JavaKind getStorageKind() {
        return this.getType().getStorageKind();
    }

    public String getName() {
        return this.name;
    }

    public SubstrateType getType() {
        return this.type;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getOffset() {
        return this.getLocation();
    }

    public boolean isInternal() {
        return false;
    }

    public SubstrateType getDeclaringClass() {
        return this.declaringClass;
    }

    public Annotation[] getAnnotations() {
        throw VMError.unimplemented("Annotations are not available for JIT compilation at image run time");
    }

    public Annotation[] getDeclaredAnnotations() {
        throw VMError.unimplemented("Annotations are not available for JIT compilation at image run time");
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        throw VMError.unimplemented("Annotations are not available for JIT compilation at image run time");
    }

    public boolean isSynthetic() {
        throw VMError.intentionallyUnimplemented();
    }

    @Override
    public boolean isValueAvailable() {
        return true;
    }

    @Override
    public boolean isInBaseLayer() {
        return false;
    }

    @Override
    public JavaConstant getStaticFieldBase() {
        throw VMError.intentionallyUnimplemented();
    }

    public String toString() {
        return "SubstrateField<" + this.format("%h.%n") + " location: " + this.location + ">";
    }
}

