/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.methodhandles;

import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.fieldvaluetransformer.NewEmptyArrayFieldValueTransformer;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.methodhandles.MethodHandleInvokerRenamingSubstitutionProcessor;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.ref.SoftReference;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.Wrapper;

@AutomaticallyRegisteredFeature
public class MethodHandleFeature
implements InternalFeature {
    private Method memberNameIsMethod;
    private Method memberNameIsConstructor;
    private Method memberNameIsField;
    private Method memberNameGetMethodType;
    private Field typedAccessors;
    private Field typedCollectors;
    private Object runtimeMethodTypeInternTable;
    private Method referencedKeySetAdd;
    private MethodHandleInvokerRenamingSubstitutionProcessor substitutionProcessor;
    private Set<Object> heapSpeciesData = new HashSet<Object>();

    public void duringSetup(Feature.DuringSetupAccess access) {
        Class memberNameClass = ReflectionUtil.lookupClass((String)"java.lang.invoke.MemberName");
        this.memberNameIsMethod = ReflectionUtil.lookupMethod((Class)memberNameClass, (String)"isMethod", (Class[])new Class[0]);
        this.memberNameIsConstructor = ReflectionUtil.lookupMethod((Class)memberNameClass, (String)"isConstructor", (Class[])new Class[0]);
        this.memberNameIsField = ReflectionUtil.lookupMethod((Class)memberNameClass, (String)"isField", (Class[])new Class[0]);
        this.memberNameGetMethodType = ReflectionUtil.lookupMethod((Class)memberNameClass, (String)"getMethodType", (Class[])new Class[0]);
        Class arrayAccessorClass = ReflectionUtil.lookupClass((String)"java.lang.invoke.MethodHandleImpl$ArrayAccessor");
        this.typedAccessors = ReflectionUtil.lookupField((Class)arrayAccessorClass, (String)"TYPED_ACCESSORS");
        Class makersClass = ReflectionUtil.lookupClass((String)"java.lang.invoke.MethodHandleImpl$Makers");
        this.typedCollectors = ReflectionUtil.lookupField((Class)makersClass, (String)"TYPED_COLLECTORS");
        if (JavaVersionUtil.JAVA_SPEC >= 22) {
            try {
                Class referencedKeySetClass = ReflectionUtil.lookupClass((String)"jdk.internal.util.ReferencedKeySet");
                if (JavaVersionUtil.JAVA_SPEC >= 24) {
                    create = ReflectionUtil.lookupMethod((Class)referencedKeySetClass, (String)"create", (Class[])new Class[]{Boolean.TYPE, Supplier.class});
                    this.runtimeMethodTypeInternTable = create.invoke(null, false, () -> new ConcurrentHashMap(512));
                } else {
                    create = ReflectionUtil.lookupMethod((Class)referencedKeySetClass, (String)"create", (Class[])new Class[]{Boolean.TYPE, Boolean.TYPE, Supplier.class});
                    this.runtimeMethodTypeInternTable = create.invoke(null, false, true, () -> new ConcurrentHashMap(512));
                }
                this.referencedKeySetAdd = ReflectionUtil.lookupMethod((Class)referencedKeySetClass, (String)"add", (Class[])new Class[]{Object.class});
            }
            catch (ReflectiveOperationException e) {
                throw VMError.shouldNotReachHere(e);
            }
        } else {
            Class concurrentWeakInternSetClass = ReflectionUtil.lookupClass((String)"java.lang.invoke.MethodType$ConcurrentWeakInternSet");
            this.runtimeMethodTypeInternTable = ReflectionUtil.newInstance((Class)concurrentWeakInternSetClass);
            this.referencedKeySetAdd = ReflectionUtil.lookupMethod((Class)concurrentWeakInternSetClass, (String)"add", (Class[])new Class[]{Object.class});
        }
        FeatureImpl.DuringSetupAccessImpl accessImpl = (FeatureImpl.DuringSetupAccessImpl)access;
        this.substitutionProcessor = new MethodHandleInvokerRenamingSubstitutionProcessor(accessImpl.getBigBang());
        accessImpl.registerSubstitutionProcessor(this.substitutionProcessor);
        accessImpl.registerObjectReachableCallback(memberNameClass, (a1, member, reason) -> this.registerHeapMemberName((Member)member));
        accessImpl.registerObjectReachableCallback(MethodType.class, (a1, methodType, reason) -> this.registerHeapMethodType((MethodType)methodType));
        Class speciesDataClass = ReflectionUtil.lookupClass((String)"java.lang.invoke.BoundMethodHandle$SpeciesData");
        accessImpl.registerObjectReachableCallback(speciesDataClass, (a1, speciesData, reason) -> this.registerHeapSpeciesData(speciesData));
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        MethodHandleFeature.eagerlyInitializeMHImplFunctions();
        MethodHandleFeature.eagerlyInitializeMHImplConstantHandles();
        MethodHandleFeature.eagerlyInitializeInvokersFunctions();
        MethodHandleFeature.eagerlyInitializeValueConversionsCaches();
        MethodHandleFeature.eagerlyInitializeCallSite();
        access.registerSubtypeReachabilityHandler(MethodHandleFeature::registerVarHandleMethodsForReflection, VarHandle.class);
        access.registerSubtypeReachabilityHandler(MethodHandleFeature::scanBoundMethodHandle, ReflectionUtil.lookupClass((String)"java.lang.invoke.BoundMethodHandle"));
        AnalysisMetaAccess metaAccess = access.getMetaAccess();
        final ImageHeapScanner heapScanner = access.getUniverse().getHeapScanner();
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)ReflectionUtil.lookupClass((String)"java.lang.invoke.ClassSpecializer"), (String)"cache"), new FieldValueTransformerWithAvailability(){
            private static final Class<?> SPECIES_DATA_CLASS = ReflectionUtil.lookupClass((String)"java.lang.invoke.ClassSpecializer$SpeciesData");

            @Override
            public boolean isAvailable() {
                return BuildPhaseProvider.isHostedUniverseBuilt();
            }

            public Object transform(Object receiver, Object originalValue) {
                ConcurrentHashMap originalMap = (ConcurrentHashMap)originalValue;
                ConcurrentHashMap filteredMap = new ConcurrentHashMap();
                originalMap.forEach((key, speciesData) -> {
                    if (MethodHandleFeature.this.heapSpeciesData.contains(speciesData)) {
                        filteredMap.put(key, speciesData);
                    }
                });
                MethodHandleFeature.this.heapSpeciesData = null;
                return filteredMap;
            }
        });
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)ReflectionUtil.lookupClass((String)"java.lang.invoke.DirectMethodHandle"), (String)"ACCESSOR_FORMS"), NewEmptyArrayFieldValueTransformer.INSTANCE);
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)ReflectionUtil.lookupClass((String)"java.lang.invoke.MethodType"), (String)"internTable"), (receiver, originalValue) -> this.runtimeMethodTypeInternTable);
        FieldValueTransformerWithAvailability methodHandleArrayTransformer = new FieldValueTransformerWithAvailability(){

            @Override
            public boolean isAvailable() {
                return BuildPhaseProvider.isHostedUniverseBuilt();
            }

            public Object transform(Object receiver, Object originalValue) {
                MethodHandle[] originalArray = (MethodHandle[])originalValue;
                MethodHandle[] filteredArray = new MethodHandle[originalArray.length];
                for (int i = 0; i < originalArray.length; ++i) {
                    MethodHandle handle = originalArray[i];
                    if (handle == null || !heapScanner.isObjectReachable((Object)handle)) continue;
                    filteredArray[i] = handle;
                }
                return filteredArray;
            }
        };
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)ReflectionUtil.lookupClass((String)"java.lang.invoke.ClassSpecializer$SpeciesData"), (String)"transformHelpers"), methodHandleArrayTransformer);
        access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)ReflectionUtil.lookupClass((String)"java.lang.invoke.MethodHandleImpl"), (String)"ARRAYS"), methodHandleArrayTransformer);
        if (JavaVersionUtil.JAVA_SPEC >= 24) {
            Class referencedKeyMapClazz = ReflectionUtil.lookupClass((String)"jdk.internal.util.ReferencedKeyMap");
            final Method createMethod = ReflectionUtil.lookupMethod((Class)referencedKeyMapClazz, (String)"create", (Class[])new Class[]{Boolean.TYPE, Supplier.class});
            final Method concurrentHashMapSupplierMethod = ReflectionUtil.lookupMethod((Class)referencedKeyMapClazz, (String)"concurrentHashMapSupplier", (Class[])new Class[0]);
            Class clazz = ReflectionUtil.lookupClass((String)"java.lang.invoke.StringConcatFactory$InlineHiddenClassStrategy$MethodHandlePair");
            final Method constructorGetter = ReflectionUtil.lookupMethod((Class)clazz, (String)"constructor", (Class[])new Class[0]);
            final Method concatenatorGetter = ReflectionUtil.lookupMethod((Class)clazz, (String)"concatenator", (Class[])new Class[0]);
            access.registerFieldValueTransformer(ReflectionUtil.lookupField((Class)ReflectionUtil.lookupClass((String)"java.lang.invoke.StringConcatFactory$InlineHiddenClassStrategy"), (String)"CACHE"), new FieldValueTransformerWithAvailability(){

                @Override
                public boolean isAvailable() {
                    return BuildPhaseProvider.isHostedUniverseBuilt();
                }

                public Object transform(Object receiver, Object originalValue) {
                    Map cache = (Map)originalValue;
                    Map result = (Map)ReflectionUtil.invokeMethod((Method)createMethod, null, (Object[])new Object[]{true, ReflectionUtil.invokeMethod((Method)concurrentHashMapSupplierMethod, null, (Object[])new Object[0])});
                    for (Map.Entry entry : cache.entrySet()) {
                        SoftReference value = (SoftReference)entry.getValue();
                        Object object = value.get();
                        MethodHandle constructor = (MethodHandle)ReflectionUtil.invokeMethod((Method)constructorGetter, object, (Object[])new Object[0]);
                        MethodHandle concatenator = (MethodHandle)ReflectionUtil.invokeMethod((Method)concatenatorGetter, object, (Object[])new Object[0]);
                        if (constructor == null || concatenator == null || !heapScanner.isObjectReachable((Object)constructor) || !heapScanner.isObjectReachable((Object)concatenator)) continue;
                        result.put(entry.getKey(), value);
                    }
                    return result;
                }
            });
        }
        Class lambdaFormClass = ReflectionUtil.lookupClass((String)"java.lang.invoke.LambdaForm");
        Class basicTypeClass = ReflectionUtil.lookupClass((String)"java.lang.invoke.LambdaForm$BasicType");
        Method createFormsForMethod = ReflectionUtil.lookupMethod((Class)lambdaFormClass, (String)"createFormsFor", (Class[])new Class[]{basicTypeClass});
        try {
            for (Object type : (Object[])ReflectionUtil.readStaticField((Class)basicTypeClass, (String)"ALL_TYPES")) {
                createFormsForMethod.invoke(null, type);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            VMError.shouldNotReachHere("Can not invoke createFormsForm method to register base types from the java.lang.invoke.LambdaForm$BasicType class.");
        }
    }

    private static void eagerlyInitializeMHImplFunctions() {
        Class methodHandleImplClass = ReflectionUtil.lookupClass((String)"java.lang.invoke.MethodHandleImpl");
        int count = ((Object[])ReflectionUtil.readStaticField((Class)methodHandleImplClass, (String)"NFS")).length;
        Method getFunctionMethod = ReflectionUtil.lookupMethod((Class)methodHandleImplClass, (String)"getFunction", (Class[])new Class[]{Byte.TYPE});
        for (int i = 0; i < count; ++i) {
            ReflectionUtil.invokeMethod((Method)getFunctionMethod, null, (Object[])new Object[]{(byte)i});
        }
    }

    private static void eagerlyInitializeMHImplConstantHandles() {
        Class methodHandleImplClass = ReflectionUtil.lookupClass((String)"java.lang.invoke.MethodHandleImpl");
        int count = ((Object[])ReflectionUtil.readStaticField((Class)methodHandleImplClass, (String)"HANDLES")).length;
        Method getConstantHandleMethod = ReflectionUtil.lookupMethod((Class)methodHandleImplClass, (String)"getConstantHandle", (Class[])new Class[]{Integer.TYPE});
        for (int i = 0; i < count; ++i) {
            ReflectionUtil.invokeMethod((Method)getConstantHandleMethod, null, (Object[])new Object[]{i});
        }
    }

    private static void eagerlyInitializeInvokersFunctions() {
        Class invokerksClass = ReflectionUtil.lookupClass((String)"java.lang.invoke.Invokers");
        int count = ((Object[])ReflectionUtil.readStaticField((Class)invokerksClass, (String)"NFS")).length;
        Method getFunctionMethod = ReflectionUtil.lookupMethod((Class)invokerksClass, (String)"getFunction", (Class[])new Class[]{Byte.TYPE});
        for (int i = 0; i < count; ++i) {
            ReflectionUtil.invokeMethod((Method)getFunctionMethod, null, (Object[])new Object[]{(byte)i});
        }
    }

    private static void eagerlyInitializeValueConversionsCaches() {
        ValueConversions.ignore();
        for (Wrapper src : Wrapper.values()) {
            if (src != Wrapper.VOID && src.primitiveType().isPrimitive()) {
                ValueConversions.boxExact(src);
                ValueConversions.unboxExact(src, false);
                ValueConversions.unboxExact(src, true);
                ValueConversions.unboxWiden(src);
                ValueConversions.unboxCast(src);
            }
            for (Wrapper dst : Wrapper.values()) {
                if (src == Wrapper.VOID || dst == Wrapper.VOID || src != dst && (!src.primitiveType().isPrimitive() || !dst.primitiveType().isPrimitive())) continue;
                ValueConversions.convertPrimitive(src, dst);
            }
        }
    }

    private static void eagerlyInitializeCallSite() {
        ReflectionUtil.invokeMethod((Method)ReflectionUtil.lookupMethod(CallSite.class, (String)"getTargetHandle", (Class[])new Class[0]), null, (Object[])new Object[0]);
        ReflectionUtil.invokeMethod((Method)ReflectionUtil.lookupMethod(CallSite.class, (String)"uninitializedCallSiteHandle", (Class[])new Class[0]), null, (Object[])new Object[0]);
    }

    private static void registerVarHandleMethodsForReflection(Feature.FeatureAccess access, Class<?> subtype) {
        if (subtype.getPackage().getName().equals("java.lang.invoke") && subtype != VarHandle.class) {
            RuntimeReflection.register((Executable[])subtype.getDeclaredMethods());
        }
    }

    public void registerHeapMethodType(MethodType methodType) {
        try {
            this.referencedKeySetAdd.invoke(this.runtimeMethodTypeInternTable, methodType);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    public void registerHeapMemberName(Member memberName) {
        try {
            Class<?> declaringClass = memberName.getDeclaringClass();
            boolean isMethod = (Boolean)this.memberNameIsMethod.invoke((Object)memberName, new Object[0]);
            boolean isConstructor = (Boolean)this.memberNameIsConstructor.invoke((Object)memberName, new Object[0]);
            boolean isField = (Boolean)this.memberNameIsField.invoke((Object)memberName, new Object[0]);
            String name = isMethod || isField ? memberName.getName() : null;
            Class<?>[] paramTypes = null;
            if (isMethod || isConstructor) {
                MethodType methodType = (MethodType)this.memberNameGetMethodType.invoke((Object)memberName, new Object[0]);
                paramTypes = methodType.parameterArray();
            }
            if (isMethod) {
                RuntimeReflection.register((Executable[])new Executable[]{declaringClass.getDeclaredMethod(name, paramTypes)});
            } else if (isConstructor) {
                RuntimeReflection.register((Executable[])new Executable[]{declaringClass.getDeclaredConstructor(paramTypes)});
            } else if (isField) {
                RuntimeReflection.register((Field[])new Field[]{declaringClass.getDeclaredField(name)});
            }
        }
        catch (NoSuchFieldException | NoSuchMethodException declaringClass) {
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    public void registerHeapSpeciesData(Object speciesData) {
        VMError.guarantee(this.heapSpeciesData != null, "The collected SpeciesData objects have already been processed.");
        this.heapSpeciesData.add(speciesData);
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        int numTypes = access.getUniverse().getTypes().size();
        access.rescanRoot(this.typedAccessors);
        access.rescanRoot(this.typedCollectors);
        access.rescanObject(this.runtimeMethodTypeInternTable);
        if (numTypes != access.getUniverse().getTypes().size()) {
            access.requireAnalysisIteration();
        }
    }

    private static void scanBoundMethodHandle(Feature.DuringAnalysisAccess a, Class<?> bmhSubtype) {
        for (Field field : bmhSubtype.getDeclaredFields()) {
            if (!field.getName().startsWith("arg")) continue;
            RuntimeReflection.register((Field[])new Field[]{field});
            if (field.getType().isPrimitive()) continue;
            field.setAccessible(true);
        }
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        access.getBigBang().postTask(unused -> {
            Field bmhSpeciesField = ReflectionUtil.lookupField((boolean)true, (Class)bmhSubtype, (String)"BMH_SPECIES");
            if (bmhSpeciesField != null) {
                access.rescanRoot(bmhSpeciesField);
            }
        });
        if (!access.getBigBang().executorIsStarted()) {
            access.requireAnalysisIteration();
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        assert (this.substitutionProcessor == null || this.substitutionProcessor.checkAllTypeNames());
    }

    public MethodHandleInvokerRenamingSubstitutionProcessor getMethodHandleSubstitutionProcessor() {
        return this.substitutionProcessor;
    }
}

