/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageGenerator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class FoldedReflectionFeature
implements InternalFeature {
    private static final List<String> SKIPPED_PATTERNS = Arrays.asList("com.oracle.svm.core.snippets.ImplicitExceptions", "sun.misc.Unsafe");
    private final Set<Executable> executables = ConcurrentHashMap.newKeySet();
    private final Set<Field> fields = ConcurrentHashMap.newKeySet();

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return Options.DumpFoldedReflectionElements.getValue();
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        access.registerObjectReachableCallback(Executable.class, (analysisAccess, executable, reason) -> this.executables.add((Executable)executable));
        access.registerObjectReachableCallback(Field.class, (analysisAccess, field, reason) -> this.fields.add((Field)field));
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        BigBang bb = ((FeatureImpl.AfterAnalysisAccessImpl)access).getBigBang();
        Path reportsPath = NativeImageGenerator.generatedFiles(HostedOptionValues.singleton()).resolve("reports");
        ReportUtils.report((String)"folded reflection elements", (Path)reportsPath.resolve("folded_reflection_stats.json"), writer -> this.printElements((PrintWriter)writer, bb));
    }

    private void printElements(PrintWriter printWriter, BigBang bb) {
        Map<Class<?>, ClassConfiguration> typeConfiguration = this.groupElementsPerClass(bb);
        try (JsonWriter writer = new JsonWriter((Writer)printWriter);){
            writer.append('[').newline().indent();
            Iterator<ClassConfiguration> it = typeConfiguration.values().iterator();
            while (it.hasNext()) {
                FoldedReflectionFeature.printClass(writer, it.next());
                if (!it.hasNext()) continue;
                writer.append(',');
            }
            writer.unindent().newline().append(']');
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<Class<?>, ClassConfiguration> groupElementsPerClass(BigBang bb) {
        HashMap typeConfiguration = new HashMap();
        AnalysisMetaAccess metaAccess = bb.getMetaAccess();
        for (Executable executable : this.executables) {
            AnalysisMethod method = metaAccess.lookupJavaMethod(executable);
            if (!method.isReachable() || FoldedReflectionFeature.shouldSkip(method)) continue;
            typeConfiguration.computeIfAbsent(executable.getDeclaringClass(), (Function<Class, ClassConfiguration>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.Class<?> ), (Ljava/lang/Class;)Lcom/oracle/svm/hosted/reflect/FoldedReflectionFeature$ClassConfiguration;)()).executables.add(executable);
        }
        for (Field field : this.fields) {
            AnalysisField analysisField = metaAccess.lookupJavaField(field);
            if (!analysisField.isReachable()) continue;
            typeConfiguration.computeIfAbsent(field.getDeclaringClass(), (Function<Class, ClassConfiguration>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.Class<?> ), (Ljava/lang/Class;)Lcom/oracle/svm/hosted/reflect/FoldedReflectionFeature$ClassConfiguration;)()).fields.add(field);
        }
        return typeConfiguration;
    }

    private static void printClass(JsonWriter writer, ClassConfiguration classConfig) throws IOException {
        writer.append('{').newline().indent();
        writer.quote("name").append(':').quote(classConfig.clazz.getName()).append(',').quote("methods").append(":").append("[");
        FoldedReflectionFeature.printMethods(writer, classConfig);
        writer.append("]");
        if (!classConfig.fields.isEmpty()) {
            writer.append(',');
            FoldedReflectionFeature.printFields(writer, classConfig);
        }
        writer.unindent().newline().append('}');
    }

    private static boolean shouldSkip(AnalysisMethod method) {
        String qualifiedName = method.getQualifiedName();
        for (String pattern : SKIPPED_PATTERNS) {
            if (!qualifiedName.startsWith(pattern)) continue;
            return true;
        }
        return false;
    }

    private static void printFields(JsonWriter writer, ClassConfiguration classConfig) throws IOException {
        writer.quote("fields").append(':');
        writer.append("[");
        writer.newline();
        writer.indent();
        Iterator<Field> it = classConfig.fields.iterator();
        while (it.hasNext()) {
            writer.append('{').quote("name").append(":").quote(it.next().getName()).append('}');
            if (!it.hasNext()) continue;
            writer.append(',');
        }
        writer.unindent();
        writer.newline();
        writer.append("]");
    }

    private static void printMethods(JsonWriter writer, ClassConfiguration classConfig) throws IOException {
        Iterator<Executable> it = classConfig.executables.iterator();
        while (it.hasNext()) {
            Executable executable = it.next();
            writer.append("{");
            writer.newline();
            writer.indent();
            writer.quote("name").append(":").quote(executable instanceof Constructor ? "<init>" : executable.getName()).append(",").quote("parameterTypes").append(":").append("[");
            Class<?>[] parameterTypes = executable.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                writer.quote(parameterTypes[i].getName());
                if (i + 1 >= parameterTypes.length) continue;
                writer.append(',');
            }
            writer.append("]");
            writer.newline();
            writer.unindent();
            writer.append("}");
            if (!it.hasNext()) continue;
            writer.append(",");
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> DumpFoldedReflectionElements = new HostedOptionKey<Boolean>(false);
    }

    static class ClassConfiguration {
        public final Class<?> clazz;
        public final Set<Executable> executables = new HashSet<Executable>();
        public final Set<Field> fields = new HashSet<Field>();

        ClassConfiguration(Class<?> clazz) {
            this.clazz = clazz;
        }
    }
}

