/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.imagelayer.BuildingImageLayerPredicate;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import java.util.EnumSet;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticallyRegisteredImageSingleton(onlyWith={BuildingImageLayerPredicate.class})
class MethodTableFirstIDTracker
implements LayeredImageSingleton {
    public final int startingID;
    public int nextStartingId = -1;

    MethodTableFirstIDTracker() {
        this(0);
    }

    static MethodTableFirstIDTracker singleton() {
        return (MethodTableFirstIDTracker)ImageSingletons.lookup(MethodTableFirstIDTracker.class);
    }

    private MethodTableFirstIDTracker(int id) {
        this.startingID = id;
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        assert (this.nextStartingId > 0) : this.nextStartingId;
        writer.writeInt("startingID", this.nextStartingId);
        return LayeredImageSingleton.PersistFlags.CREATE;
    }

    public static Object createFromLoader(ImageSingletonLoader loader) {
        return new MethodTableFirstIDTracker(loader.readInt("startingID"));
    }
}

