/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.compacting;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.memory.NullableNativeMemory;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.ObjectAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.struct.UniqueLocationIdentity;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class MarkStack {
    private static final int SEGMENT_SIZE = 65472;
    private Segment top;
    private int cursor;

    @Fold
    static int entriesPerSegment() {
        return (65472 - SizeOf.get(Segment.class)) / ConfigurationValues.getObjectLayout().getReferenceSize();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public MarkStack() {
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void push(Object obj) {
        assert (obj != null);
        if (this.top.isNull() || this.cursor == MarkStack.entriesPerSegment()) {
            this.top = MarkStack.allocateSegment(this.top);
            this.cursor = 0;
        }
        UnsignedWord offset = MarkStack.getOffsetAtIndex(this.cursor);
        ObjectAccess.writeObject((Object)this.top, (WordBase)offset, (Object)obj);
        ++this.cursor;
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Object pop() {
        assert (!this.isEmpty());
        --this.cursor;
        UnsignedWord offset = MarkStack.getOffsetAtIndex(this.cursor);
        Object obj = ObjectAccess.readObject((Object)this.top, (WordBase)offset);
        assert (obj != null);
        if (this.cursor == 0 && this.top.getNext().isNonNull()) {
            Segment t = this.top;
            this.top = this.top.getNext();
            this.cursor = MarkStack.entriesPerSegment();
            NullableNativeMemory.free(t);
        }
        return obj;
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isEmpty() {
        assert (this.cursor != 0 || this.top.isNull() || this.top.getNext().isNull()) : "should see cursor == 0 only with a single segment (or none)";
        return this.top.isNull() || this.cursor == 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Segment allocateSegment(Segment next) {
        UnsignedWord size = WordFactory.unsigned((int)65472);
        Segment segment = (Segment)NullableNativeMemory.malloc(size, NmtCategory.GC);
        VMError.guarantee(segment.isNonNull(), "Could not allocate mark stack memory: malloc() returned null.");
        segment.setNext(next);
        return segment;
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getOffsetAtIndex(int index) {
        int refSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        return WordFactory.unsigned((int)index).multiply(refSize).add(SizeOf.unsigned(Segment.class));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void tearDown() {
        if (this.top.isNonNull()) {
            assert (this.top.getNext().isNull());
            NullableNativeMemory.free(this.top);
            this.top = (Segment)WordFactory.nullPointer();
        }
    }

    @RawStructure
    static interface Segment
    extends PointerBase {
        @RawField
        @UniqueLocationIdentity
        public Segment getNext();

        @RawField
        @UniqueLocationIdentity
        public void setNext(Segment var1);
    }
}

