/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.graal.lir.DeoptEntryOp;
import com.oracle.svm.core.graal.nodes.DeoptEntrySupport;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.gen.NodeLIRBuilder;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LabelRef;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.DeoptimizingNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.UnreachableBeginNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.debug.ControlFlowAnchored;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.NodeWithState;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Anchor}, cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class DeoptEntryNode
extends WithExceptionNode
implements DeoptEntrySupport,
DeoptimizingNode.DeoptAfter,
SingleMemoryKill,
ControlFlowAnchored {
    public static final NodeClass<DeoptEntryNode> TYPE = NodeClass.create(DeoptEntryNode.class);
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateAfter;
    private final int proxifiedInvokeBci;

    protected DeoptEntryNode(int proxifiedInvokeBci) {
        super(TYPE, StampFactory.forVoid());
        this.proxifiedInvokeBci = proxifiedInvokeBci;
    }

    public static DeoptEntryNode create(int proxifiedInvokeBci) {
        assert (proxifiedInvokeBci != -5);
        return new DeoptEntryNode(proxifiedInvokeBci);
    }

    public static DeoptEntryNode create() {
        return new DeoptEntryNode(-5);
    }

    public void generate(NodeLIRBuilderTool gen) {
        LabelRef exceptionRef;
        AbstractBeginNode exceptionNode = this.exceptionEdge();
        if (exceptionNode instanceof UnreachableBeginNode) {
            exceptionRef = null;
        } else {
            NodeLIRBuilder nodeLIRBuilder = (NodeLIRBuilder)gen;
            exceptionRef = nodeLIRBuilder.getLIRBlock((FixedNode)exceptionNode);
            exceptionRef.getTargetBlock().setIndirectBranchTarget();
        }
        gen.getLIRGeneratorTool().append((LIRInstruction)new DeoptEntryOp(((NodeLIRBuilder)gen).stateForWithExceptionEdge((NodeWithState)this, this.stateAfter(), exceptionRef)));
        gen.getLIRGeneratorTool().emitJump(((NodeLIRBuilder)gen).getLIRBlock((FixedNode)this.next()));
    }

    public boolean canDeoptimize() {
        return true;
    }

    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public FrameState stateAfter() {
        return this.stateAfter;
    }

    public void setStateAfter(FrameState x) {
        assert (x == null || x.isAlive()) : "frame state must be in a graph";
        this.updateUsages((Node)this.stateAfter, (Node)x);
        this.stateAfter = x;
    }

    public boolean hasSideEffect() {
        return true;
    }

    @Override
    public int getProxifiedInvokeBci() {
        return this.proxifiedInvokeBci;
    }
}

