/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.jdk.management.SubstrateThreadMXBean;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.events.NativeMemoryUsagePeakEvent;
import com.oracle.svm.core.jfr.events.NativeMemoryUsageTotalPeakEvent;
import com.oracle.svm.core.jfr.events.ThreadAllocationStatisticsEvent;
import com.oracle.svm.core.jfr.events.ThreadCPULoadEvent;
import com.oracle.svm.core.nmt.NativeMemoryTracking;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import jdk.jfr.Event;
import jdk.jfr.Name;
import jdk.jfr.Period;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;

@Name(value="EveryChunkPeriodEvents")
@Period(value="everyChunk")
public class EveryChunkNativePeriodicEvents
extends Event {
    public static void emit() {
        EveryChunkNativePeriodicEvents.emitJavaThreadStats();
        EveryChunkNativePeriodicEvents.emitPhysicalMemory(PhysicalMemory.usedSize());
        EveryChunkNativePeriodicEvents.emitClassLoadingStatistics();
        EveryChunkNativePeriodicEvents.emitPerThreadEvents();
        EveryChunkNativePeriodicEvents.emitNativeMemoryTrackingEvents();
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emitJavaThreadStats() {
        if (JfrEvent.JavaThreadStatistics.shouldEmit()) {
            SubstrateThreadMXBean threadMXBean = (SubstrateThreadMXBean)ImageSingletons.lookup(SubstrateThreadMXBean.class);
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.JavaThreadStatistics);
            JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks());
            JfrNativeEventWriter.putLong(data, threadMXBean.getThreadCount());
            JfrNativeEventWriter.putLong(data, threadMXBean.getDaemonThreadCount());
            JfrNativeEventWriter.putLong(data, threadMXBean.getTotalStartedThreadCount());
            JfrNativeEventWriter.putLong(data, threadMXBean.getPeakThreadCount());
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emitPhysicalMemory(long usedSize) {
        if (JfrEvent.PhysicalMemory.shouldEmit()) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.PhysicalMemory);
            JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks());
            JfrNativeEventWriter.putLong(data, PhysicalMemory.size().rawValue());
            JfrNativeEventWriter.putLong(data, usedSize);
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emitClassLoadingStatistics() {
        if (JfrEvent.ClassLoadingStatistics.shouldEmit()) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.ClassLoadingStatistics);
            JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks());
            JfrNativeEventWriter.putLong(data, Heap.getHeap().getClassCount());
            JfrNativeEventWriter.putLong(data, 0L);
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }

    private static void emitNativeMemoryTrackingEvents() {
        if (VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
            EveryChunkNativePeriodicEvents.emitJdkNmtEvents(NmtCategory.values());
            EveryChunkNativePeriodicEvents.emitNmtPeakEvents();
        }
    }

    private static void emitNmtPeakEvents() {
        NativeMemoryUsageTotalPeakEvent nmtTotalPeakEvent = new NativeMemoryUsageTotalPeakEvent();
        long totalPeakMalloc = NativeMemoryTracking.singleton().getPeakTotalMallocMemory();
        long totalPeakCommittedVM = NativeMemoryTracking.singleton().getPeakTotalCommittedVirtualMemory();
        long totalPeakReservedVM = NativeMemoryTracking.singleton().getPeakTotalReservedVirtualMemory();
        nmtTotalPeakEvent.peakCommitted = totalPeakCommittedVM + totalPeakMalloc;
        nmtTotalPeakEvent.peakReserved = totalPeakReservedVM + totalPeakMalloc;
        nmtTotalPeakEvent.countAtPeak = NativeMemoryTracking.singleton().getCountAtPeakTotalMallocMemory();
        nmtTotalPeakEvent.commit();
        for (NmtCategory nmtCategory : NmtCategory.values()) {
            NativeMemoryUsagePeakEvent nmtPeakEvent = new NativeMemoryUsagePeakEvent();
            nmtPeakEvent.type = nmtCategory.getName();
            long peakMalloc = NativeMemoryTracking.singleton().getPeakMallocMemory(nmtCategory);
            long peakCommittedVM = NativeMemoryTracking.singleton().getPeakCommittedVirtualMemory(nmtCategory);
            long peakReservedVM = NativeMemoryTracking.singleton().getPeakReservedVirtualMemory(nmtCategory);
            nmtPeakEvent.peakCommitted = peakCommittedVM + peakMalloc;
            nmtPeakEvent.peakReserved = peakReservedVM + peakMalloc;
            nmtPeakEvent.countAtPeak = NativeMemoryTracking.singleton().getCountAtPeakMallocMemory(nmtCategory);
            nmtPeakEvent.commit();
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emitJdkNmtEvents(NmtCategory[] nmtCategories) {
        boolean emitNativeMemoryUsageEvent = JfrEvent.NativeMemoryUsage.shouldEmit();
        boolean emitNativeMemoryUsageTotalEvent = JfrEvent.NativeMemoryUsageTotal.shouldEmit();
        if (!emitNativeMemoryUsageEvent && !emitNativeMemoryUsageTotalEvent) {
            return;
        }
        JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
        JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
        long timestamp = JfrTicks.elapsedTicks();
        if (emitNativeMemoryUsageEvent) {
            for (NmtCategory nmtCategory : nmtCategories) {
                NativeMemoryTracking nmt = NativeMemoryTracking.singleton();
                long mallocMemory = nmt.getMallocMemory(nmtCategory);
                long committedVM = nmt.getCommittedVirtualMemory(nmtCategory);
                long reservedVM = nmt.getReservedVirtualMemory(nmtCategory);
                JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.NativeMemoryUsage);
                JfrNativeEventWriter.putLong(data, timestamp);
                JfrNativeEventWriter.putLong(data, nmtCategory.ordinal());
                JfrNativeEventWriter.putLong(data, mallocMemory + reservedVM);
                JfrNativeEventWriter.putLong(data, mallocMemory + committedVM);
                JfrNativeEventWriter.endSmallEvent(data);
            }
        }
        if (emitNativeMemoryUsageTotalEvent) {
            NativeMemoryTracking nmt = NativeMemoryTracking.singleton();
            long totalMallocMemory = nmt.getTotalMallocMemory();
            long totalCommittedVM = nmt.getTotalCommittedVirtualMemory();
            long totalReservedVM = nmt.getTotalReservedVirtualMemory();
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.NativeMemoryUsageTotal);
            JfrNativeEventWriter.putLong(data, timestamp);
            JfrNativeEventWriter.putLong(data, totalMallocMemory + totalReservedVM);
            JfrNativeEventWriter.putLong(data, totalMallocMemory + totalCommittedVM);
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }

    private static void emitPerThreadEvents() {
        if (EveryChunkNativePeriodicEvents.needsVMOperation()) {
            EmitPeriodicPerThreadEventsOperation vmOp = new EmitPeriodicPerThreadEventsOperation();
            vmOp.enqueue();
        }
    }

    @Uninterruptible(reason="Used to avoid the VM operation if it is not absolutely needed.")
    private static boolean needsVMOperation() {
        return JfrEvent.ThreadCPULoad.shouldEmit() || JfrEvent.ThreadAllocationStatistics.shouldEmit();
    }

    private static final class EmitPeriodicPerThreadEventsOperation
    extends JavaVMOperation {
        EmitPeriodicPerThreadEventsOperation() {
            super(VMOperationInfos.get(EmitPeriodicPerThreadEventsOperation.class, "Emit periodic JFR events", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            IsolateThread isolateThread = VMThreads.firstThread();
            while (isolateThread.isNonNull()) {
                ThreadCPULoadEvent.emit(isolateThread);
                ThreadAllocationStatisticsEvent.emit(isolateThread);
                isolateThread = VMThreads.nextThread(isolateThread);
            }
        }
    }
}

