/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.dashboard;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.dashboard.CodeBreakdown;
import com.oracle.svm.hosted.dashboard.DashboardOptions;
import com.oracle.svm.hosted.dashboard.HeapBreakdown;
import com.oracle.svm.hosted.dashboard.PointsToBreakdown;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import jdk.graal.compiler.graphio.GraphOutput;
import jdk.graal.compiler.graphio.GraphStructure;
import jdk.graal.compiler.util.json.JsonBuilder;
import jdk.graal.compiler.util.json.JsonPrettyWriter;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class DashboardDumpFeature
implements InternalFeature {
    private StringWriter jsonOutput = null;
    private JsonWriter jsonWriter = null;
    private JsonBuilder.ObjectBuilder objectBuilder = null;

    private static boolean isHeapBreakdownDumped() {
        return DashboardOptions.DashboardAll.getValue() != false || DashboardOptions.DashboardHeap.getValue() != false;
    }

    private static boolean isPointsToDumped() {
        return DashboardOptions.DashboardAll.getValue() != false || DashboardOptions.DashboardPointsTo.getValue() != false;
    }

    private static boolean isCodeBreakdownDumped() {
        return DashboardOptions.DashboardAll.getValue() != false || DashboardOptions.DashboardCode.getValue() != false;
    }

    private static boolean isBgvFormat() {
        return DashboardOptions.DashboardBgv.getValue();
    }

    private static boolean isJsonFormat() {
        return DashboardOptions.DashboardJson.getValue() != false || DashboardDumpFeature.isPretty();
    }

    private static boolean isPretty() {
        return DashboardOptions.DashboardPretty.getValue();
    }

    private static Path getFile(String extension) {
        String fileName = DashboardOptions.DashboardDump.getValue();
        if (fileName == null) {
            fileName = SubstrateOptions.Name.getValue();
        }
        return new File(fileName + "." + extension).getAbsoluteFile().toPath();
    }

    public DashboardDumpFeature() {
        if (DashboardDumpFeature.isSane()) {
            if (DashboardDumpFeature.isJsonFormat()) {
                this.jsonOutput = new StringWriter();
                this.jsonWriter = DashboardDumpFeature.isPretty() ? new JsonPrettyWriter((Writer)this.jsonOutput) : new JsonWriter((Writer)this.jsonOutput);
                try {
                    this.objectBuilder = this.jsonWriter.objectBuilder();
                }
                catch (IOException ex) {
                    System.getLogger(DashboardDumpFeature.class.getName()).log(System.Logger.Level.ERROR, "IOException during Dashboard json dump header", (Throwable)ex);
                }
                ReportUtils.report((String)"Dashboard JSON dump header", (Path)DashboardDumpFeature.getFile("dump"), (boolean)false, os -> {});
            }
            if (DashboardDumpFeature.isBgvFormat()) {
                ReportUtils.report((String)"Dashboard BGV dump header", (Path)DashboardDumpFeature.getFile("bgv"), (boolean)false, os -> {
                    try {
                        GraphOutput.newBuilder(VoidGraphStructure.INSTANCE).build(Channels.newChannel(os)).close();
                    }
                    catch (IOException ex) {
                        System.getLogger(DashboardDumpFeature.class.getName()).log(System.Logger.Level.ERROR, "IOException during Dashboard BGV dump header", (Throwable)ex);
                    }
                });
            }
        }
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return DashboardDumpFeature.isSane();
    }

    private static boolean isSane() {
        return DashboardDumpFeature.isHeapBreakdownDumped() || DashboardDumpFeature.isPointsToDumped() || DashboardDumpFeature.isCodeBreakdownDumped();
    }

    public void onAnalysisExit(Feature.OnAnalysisExitAccess access) {
        if (DashboardDumpFeature.isPointsToDumped()) {
            PointsToBreakdown pointsTo = new PointsToBreakdown(access);
            if (DashboardDumpFeature.isJsonFormat()) {
                ReportUtils.report((String)"Dashboard PointsTo analysis JSON dump", (Path)DashboardDumpFeature.getFile("dump"), (boolean)true, os -> {
                    try (JsonBuilder.ObjectBuilder builder = this.objectBuilder.append("points-to").object();){
                        pointsTo.toJson(builder);
                    }
                    catch (IOException ex) {
                        ((FeatureImpl.AfterCompilationAccessImpl)access).getDebugContext().log("Dump of PointsTo analysis failed with: %s", (Object)ex);
                    }
                });
            }
            if (DashboardDumpFeature.isBgvFormat()) {
                ReportUtils.report((String)"Dashboard PointsTo analysis BGV dump", (Path)DashboardDumpFeature.getFile("bgv"), (boolean)true, os -> {
                    try (GraphOutput out = GraphOutput.newBuilder(VoidGraphStructure.INSTANCE).embedded(true).build(Channels.newChannel(os));){
                        out.beginGroup(null, "points-to", null, null, 0, Collections.emptyMap());
                        pointsTo.dump(out);
                        out.endGroup();
                    }
                    catch (IOException ex) {
                        ((FeatureImpl.OnAnalysisExitAccessImpl)access).getDebugContext().log("Dump of PointsTo analysis failed with: %s", (Object)ex);
                    }
                });
            }
        }
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        if (DashboardDumpFeature.isCodeBreakdownDumped() || DashboardDumpFeature.isPointsToDumped()) {
            CodeBreakdown dump = new CodeBreakdown(access);
            if (DashboardDumpFeature.isJsonFormat()) {
                ReportUtils.report((String)"Dashboard Code-Breakdown JSON dump", (Path)DashboardDumpFeature.getFile("dump"), (boolean)true, os -> {
                    try (JsonBuilder.ObjectBuilder builder = this.objectBuilder.append("code-breakdown").object();){
                        dump.toJson(builder);
                    }
                    catch (IOException ex) {
                        ((FeatureImpl.AfterCompilationAccessImpl)access).getDebugContext().log("Dump of Code-Breakdown failed with: %s", (Object)ex);
                    }
                });
            }
            if (DashboardDumpFeature.isBgvFormat()) {
                ReportUtils.report((String)"Dashboard Code-Breakdown BGV dump", (Path)DashboardDumpFeature.getFile("bgv"), (boolean)true, os -> {
                    try (GraphOutput out = GraphOutput.newBuilder(VoidGraphStructure.INSTANCE).embedded(true).build(Channels.newChannel(os));){
                        out.beginGroup(null, "code-breakdown", null, null, 0, dump.getData());
                        out.endGroup();
                    }
                    catch (IOException ex) {
                        ((FeatureImpl.AfterCompilationAccessImpl)access).getDebugContext().log("Dump of Code-Breakdown failed with: %s", (Object)ex);
                    }
                });
            }
        }
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess access) {
        if (DashboardDumpFeature.isHeapBreakdownDumped()) {
            HeapBreakdown dump = new HeapBreakdown(access);
            if (DashboardDumpFeature.isJsonFormat()) {
                ReportUtils.report((String)"Dashboard Heap-Breakdown JSON dump", (Path)DashboardDumpFeature.getFile("dump"), (boolean)true, os -> {
                    try (JsonBuilder.ObjectBuilder builder = this.objectBuilder.append("heap-breakdown").object();){
                        dump.toJson(builder);
                    }
                    catch (IOException ex) {
                        ((FeatureImpl.AfterCompilationAccessImpl)access).getDebugContext().log("Dump of Heap-Breakdown failed with: %s", (Object)ex);
                    }
                });
            }
            if (DashboardDumpFeature.isBgvFormat()) {
                ReportUtils.report((String)"Dashboard Heap-Breakdown BGV dump", (Path)DashboardDumpFeature.getFile("bgv"), (boolean)true, os -> {
                    try (GraphOutput out = GraphOutput.newBuilder(VoidGraphStructure.INSTANCE).embedded(true).build(Channels.newChannel(os));){
                        out.beginGroup(null, "heap-breakdown", null, null, 0, dump.getData());
                        out.endGroup();
                    }
                    catch (IOException ex) {
                        ((FeatureImpl.AfterHeapLayoutAccessImpl)access).getDebugContext().log("Dump of Heap-Breakdown failed with: %s", (Object)ex);
                    }
                });
            }
        }
    }

    public void cleanup() {
        if (DashboardDumpFeature.isJsonFormat()) {
            try {
                if (this.objectBuilder != null) {
                    this.objectBuilder.close();
                }
                if (this.jsonWriter != null) {
                    this.jsonWriter.close();
                }
            }
            catch (IOException ex) {
                System.getLogger(DashboardDumpFeature.class.getName()).log(System.Logger.Level.ERROR, "IOException during Dashboard json dump end", (Throwable)ex);
            }
            ReportUtils.report((String)"Dashboard JSON dump end", (Path)DashboardDumpFeature.getFile("dump"), (boolean)true, os -> {
                try (PrintWriter pw = new PrintWriter((OutputStream)os);){
                    pw.print(this.jsonOutput.toString());
                }
            });
        }
        System.out.println("Print of Dashboard dump output ended.");
    }

    public static final class VoidGraphStructure
    implements GraphStructure<Void, Void, Void, Void> {
        public static final GraphStructure<Void, Void, Void, Void> INSTANCE = new VoidGraphStructure();

        private VoidGraphStructure() {
        }

        public Void graph(Void currentGraph, Object obj) {
            return null;
        }

        public Iterable<? extends Void> nodes(Void graph) {
            return Collections.emptyList();
        }

        public int nodesCount(Void graph) {
            return 0;
        }

        public int nodeId(Void node) {
            return 0;
        }

        public boolean nodeHasPredecessor(Void node) {
            return false;
        }

        public void nodeProperties(Void graph, Void node, Map<String, ? super Object> properties) {
        }

        public Void node(Object obj) {
            return null;
        }

        public Void nodeClass(Object obj) {
            return null;
        }

        public Void classForNode(Void node) {
            return null;
        }

        public String nameTemplate(Void nodeClass) {
            return null;
        }

        public Object nodeClassType(Void nodeClass) {
            return null;
        }

        public Void portInputs(Void nodeClass) {
            return null;
        }

        public Void portOutputs(Void nodeClass) {
            return null;
        }

        public int portSize(Void port) {
            return 0;
        }

        public boolean edgeDirect(Void port, int index) {
            return false;
        }

        public String edgeName(Void port, int index) {
            return null;
        }

        public Object edgeType(Void port, int index) {
            return null;
        }

        public Collection<? extends Void> edgeNodes(Void graph, Void node, Void port, int index) {
            return null;
        }
    }
}

