/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.graal.pointsto.heap.ImageLayerSnapshotUtil;
import com.oracle.svm.core.util.ArchiveSupport;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.imagelayer.LayerArchiveSupport;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;

public class LoadLayerArchiveSupport
extends LayerArchiveSupport {
    private final Path expandedInputLayerDir;
    private final AtomicBoolean deleteLayerRoot = new AtomicBoolean();

    public LoadLayerArchiveSupport(Path layerFile, ArchiveSupport archiveSupport) {
        super(archiveSupport);
        Path inputLayerLocation = LoadLayerArchiveSupport.validateLayerFile(layerFile);
        this.expandedInputLayerDir = this.archiveSupport.createTempDir("layerRoot-", this.deleteLayerRoot);
        this.archiveSupport.expandJarToDir(inputLayerLocation, this.expandedInputLayerDir, this.deleteLayerRoot);
        this.layerProperties.loadAndVerify(inputLayerLocation, this.expandedInputLayerDir);
    }

    public Path getSharedLibraryPath() {
        return this.expandedInputLayerDir.resolve(this.layerProperties.layerName() + ".so");
    }

    public Path getSnapshotPath() {
        return this.expandedInputLayerDir.resolve(ImageLayerSnapshotUtil.snapshotFileName((String)this.layerProperties.layerName()));
    }

    public Path getSnapshotGraphsPath() {
        return this.expandedInputLayerDir.resolve(ImageLayerSnapshotUtil.snapshotGraphsFileName((String)this.layerProperties.layerName()));
    }

    private static Path validateLayerFile(Path layerFile) {
        Path fileName = layerFile.getFileName();
        if (fileName == null || !fileName.toString().endsWith(".nil")) {
            throw UserError.abort("The given layer file " + String.valueOf(layerFile) + " must end with '.nil'.", new Object[0]);
        }
        if (Files.isDirectory(layerFile, new LinkOption[0])) {
            throw UserError.abort("The given layer file " + String.valueOf(layerFile) + " is a directory and not a file.", new Object[0]);
        }
        if (!Files.isReadable(layerFile)) {
            throw UserError.abort("The given layer file " + String.valueOf(layerFile) + " cannot be read.", new Object[0]);
        }
        return layerFile;
    }
}

