/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class OpenTypeWorldConvertCallTargetPhase
extends BasePhase<CoreProviders> {
    protected void run(StructuredGraph graph, CoreProviders context) {
        for (MethodCallTargetNode callTarget : graph.getNodes(MethodCallTargetNode.TYPE).snapshot()) {
            if (!callTarget.invokeKind().isIndirect()) continue;
            this.maybeConvertCallTarget(callTarget);
        }
    }

    public void maybeConvertCallTarget(MethodCallTargetNode target) {
        AnalysisMethod aMethod;
        AnalysisMethod indirectTarget;
        ResolvedJavaMethod resolvedJavaMethod = target.targetMethod();
        if (resolvedJavaMethod instanceof AnalysisMethod && !(indirectTarget = (aMethod = (AnalysisMethod)resolvedJavaMethod).getIndirectCallTarget()).equals((Object)aMethod)) {
            target.setTargetMethod((ResolvedJavaMethod)indirectTarget);
        }
    }
}

