/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect.proxy;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.meta.BaseLayerType;
import com.oracle.svm.hosted.reflect.proxy.ProxySubstitutionType;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;

public class ProxyRenamingSubstitutionProcessor
extends SubstitutionProcessor {
    public static final String DYNAMIC_MODULE_REGEX = "jdk[.]proxy[0-9]+";
    public static final String NULL_CLASS_LOADER_NAME = "native-image-null-class-loader";
    public static final String NULL_MODULE_NAME = "native-image-null-module";
    public static final String UNNAMED_MODULE_NAME = "native-image-unnamed";
    private static final String STABLE_NAME_TEMPLATE = "/$Proxy.s";
    private final ConcurrentMap<ResolvedJavaType, ProxySubstitutionType> typeSubstitutions = new ConcurrentHashMap<ResolvedJavaType, ProxySubstitutionType>();
    private final Set<String> uniqueTypeNames = new HashSet<String>();

    public static boolean isProxyType(ResolvedJavaType type) {
        Class clazz = OriginalClassProvider.getJavaClass((JavaType)type);
        return Proxy.isProxyClass(clazz);
    }

    private static boolean isModuleDynamic(Module module) {
        return module != null && module.getName() != null && module.getName().matches(DYNAMIC_MODULE_REGEX);
    }

    public ResolvedJavaType lookup(ResolvedJavaType type) {
        if (!ProxyRenamingSubstitutionProcessor.shouldReplace(type)) {
            return type;
        }
        return this.getSubstitution(type);
    }

    private static boolean shouldReplace(ResolvedJavaType type) {
        return !(type instanceof ProxySubstitutionType) && !(type instanceof BaseLayerType) && ProxyRenamingSubstitutionProcessor.isProxyType(type);
    }

    private ProxySubstitutionType getSubstitution(ResolvedJavaType original) {
        Class clazz = OriginalClassProvider.getJavaClass((JavaType)original);
        return this.typeSubstitutions.computeIfAbsent(original, key -> new ProxySubstitutionType((ResolvedJavaType)key, this.getUniqueProxyName(clazz)));
    }

    public String getUniqueProxyName(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        Class<?>[] interfaces = clazz.getInterfaces();
        Arrays.stream(interfaces).forEach(i -> sb.append(i.getName()));
        ClassLoader classLoader = clazz.getClassLoader();
        String classLoaderName = classLoader == null ? NULL_CLASS_LOADER_NAME : classLoader.getName();
        sb.append(classLoaderName != null ? classLoaderName : classLoader.getClass().getName());
        Module module = clazz.getModule();
        if (!ProxyRenamingSubstitutionProcessor.isModuleDynamic(module)) {
            String moduleName = module == null ? NULL_MODULE_NAME : module.getName();
            sb.append(moduleName != null ? moduleName : UNNAMED_MODULE_NAME);
        }
        return this.findUniqueName(clazz, sb.toString().hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findUniqueName(Class<?> clazz, int hashCode) {
        String baseName = "L" + clazz.getPackageName().replace('.', '/') + STABLE_NAME_TEMPLATE + Integer.toHexString(hashCode);
        String name = String.valueOf(baseName) + ";";
        Set<String> set = this.uniqueTypeNames;
        synchronized (set) {
            int suffix = 1;
            while (this.uniqueTypeNames.contains(name)) {
                name = String.valueOf(baseName) + "_" + suffix + ";";
                ++suffix;
            }
            this.uniqueTypeNames.add(name);
            return name;
        }
    }

    public static boolean isNameAlwaysStable(String proxyName) {
        return proxyName.lastIndexOf(95) < 0;
    }
}

