/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.util;

import com.oracle.svm.core.util.VMError;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import sun.net.www.ParseUtil;

public class ResourcesUtils {
    private static String urlToJarPath(URL url) {
        return ResourcesUtils.urlToJarUri(url).getPath();
    }

    public static String getResourceSource(URL url, String resource, boolean fromJar) {
        try {
            String source;
            String string = source = fromJar ? ResourcesUtils.urlToJarUri(url).toString() : url.toURI().toString();
            if (!fromJar && (source = source.substring(0, source.length() - resource.length() - 1)).endsWith("/")) {
                source = source.substring(0, source.length() - 1);
            }
            return source;
        }
        catch (URISyntaxException e) {
            throw VMError.shouldNotReachHere("Cannot get uri from: " + String.valueOf(url), e);
        }
    }

    public static boolean resourceIsDirectory(URL url, boolean fromJar) throws IOException, URISyntaxException {
        if (fromJar) {
            try (JarFile jf = new JarFile(ResourcesUtils.urlToJarPath(url));){
                String path = url.getPath();
                String fullResourcePath = path.substring(path.indexOf("!") + 1);
                if (fullResourcePath.startsWith("/")) {
                    fullResourcePath = fullResourcePath.substring(1);
                }
                String decodedString = ParseUtil.decode(fullResourcePath);
                boolean bl = jf.getEntry(decodedString).isDirectory();
                return bl;
            }
        }
        return Files.isDirectory(Path.of(url.toURI()), new LinkOption[0]);
    }

    public static String getDirectoryContent(String path, boolean fromJar) throws IOException {
        TreeSet<Object> content = new TreeSet();
        if (fromJar) {
            try (JarFile jf = new JarFile(ResourcesUtils.urlToJarPath(URI.create(path).toURL()));){
                String pathSeparator = FileSystems.getDefault().getSeparator();
                String directoryPath = path.split("!")[1];
                if (directoryPath.startsWith(pathSeparator)) {
                    directoryPath = directoryPath.substring(1);
                }
                Enumeration<JarEntry> entries = jf.entries();
                while (entries.hasMoreElements()) {
                    String entry = entries.nextElement().getName();
                    if (!entry.startsWith(directoryPath)) continue;
                    String contentEntry = entry.substring(directoryPath.length());
                    if (contentEntry.startsWith(pathSeparator)) {
                        contentEntry = contentEntry.substring(1);
                    }
                    if (contentEntry.isEmpty()) continue;
                    int firstSlash = contentEntry.indexOf(pathSeparator);
                    if (firstSlash != -1) {
                        content.add(contentEntry.substring(0, firstSlash));
                        continue;
                    }
                    content.add(contentEntry);
                }
            }
        }
        try (Stream<Path> contentStream = Files.list(Path.of(path, new String[0]));){
            content = new TreeSet<String>(contentStream.map(Path::getFileName).map(Path::toString).toList());
        }
        return String.join((CharSequence)System.lineSeparator(), content);
    }

    private static URI urlToJarUri(URL url) {
        try {
            return ((JarURLConnection)url.openConnection()).getJarFileURL().toURI();
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

