/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.tck;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.tck.ResultVerifier;
import org.graalvm.polyglot.tck.TypeDescriptor;

public final class Snippet {
    private final String id;
    private final Value executableValue;
    private final TypeDescriptor type;
    private final List<? extends TypeDescriptor> parameterTypes;
    private final ResultVerifier verifier;

    private Snippet(String id, Value executableValue, TypeDescriptor type, List<? extends TypeDescriptor> parameterTypes, ResultVerifier verifier) {
        if (!executableValue.canExecute()) {
            throw new IllegalArgumentException("The executableValue has to be executable.");
        }
        this.id = id;
        this.executableValue = executableValue;
        this.type = type;
        this.parameterTypes = parameterTypes;
        this.verifier = verifier;
    }

    public String getId() {
        return this.id;
    }

    public Value getExecutableValue() {
        return this.executableValue;
    }

    public TypeDescriptor getReturnType() {
        return this.type;
    }

    public List<? extends TypeDescriptor> getParameterTypes() {
        return this.parameterTypes;
    }

    public ResultVerifier getResultVerifier() {
        return this.verifier;
    }

    public String toString() {
        return this.id + this.parameterTypes.stream().map(Object::toString).collect(Collectors.joining(", ", "(", ")")) + ':' + this.type;
    }

    public static Builder newBuilder(String id, Value executableValue, TypeDescriptor executableReturnType) {
        return new Builder(id, executableValue, executableReturnType);
    }

    public static final class Builder {
        private final String id;
        private final Value executableValue;
        private TypeDescriptor executableReturnType;
        private List<TypeDescriptor> parameterTypes;
        private ResultVerifier verifier;

        private Builder(String id, Value executableValue, TypeDescriptor executableReturnType) {
            Objects.requireNonNull(id);
            Objects.requireNonNull(executableValue);
            Objects.requireNonNull(executableReturnType);
            this.id = id;
            this.executableValue = executableValue;
            this.executableReturnType = executableReturnType;
            this.parameterTypes = new ArrayList<TypeDescriptor>();
        }

        public Builder parameterTypes(TypeDescriptor ... parameterTypes) {
            Objects.requireNonNull(parameterTypes);
            this.parameterTypes = Arrays.asList(parameterTypes);
            return this;
        }

        public Builder resultVerifier(ResultVerifier resultVerifier) {
            this.verifier = resultVerifier;
            return this;
        }

        public Snippet build() {
            return new Snippet(this.id, this.executableValue, this.executableReturnType, Collections.unmodifiableList(this.parameterTypes), this.verifier != null ? this.verifier : ResultVerifier.getDefaultResultVerifier());
        }
    }
}

