/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.tck;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.polyglot.Value;

public final class TypeDescriptor {
    private static final TypeDescriptor NOTYPE = new TypeDescriptor(new IntersectionImpl(Collections.emptySet()));
    public static final TypeDescriptor NULL = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.NULL));
    public static final TypeDescriptor BOOLEAN = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.BOOLEAN));
    public static final TypeDescriptor NUMBER = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.NUMBER));
    public static final TypeDescriptor STRING = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.STRING));
    public static final TypeDescriptor OBJECT = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.OBJECT));
    public static final TypeDescriptor ARRAY = new TypeDescriptor(new ArrayImpl(null));
    public static final TypeDescriptor HOST_OBJECT = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.HOST_OBJECT));
    public static final TypeDescriptor NATIVE_POINTER = new TypeDescriptor(new PrimitiveImpl(PrimitiveKind.NATIVE_POINTER));
    public static final TypeDescriptor EXECUTABLE = new TypeDescriptor(new ExecutableImpl(ExecutableImpl.Kind.BOTTOM, null, true, Collections.emptyList()));
    public static final TypeDescriptor EXECUTABLE_ANY = new TypeDescriptor(new ExecutableImpl(ExecutableImpl.Kind.TOP, null, true, Collections.emptyList()));
    public static final TypeDescriptor ANY = new TypeDescriptor(new UnionImpl(new HashSet<TypeDescriptorImpl>(Arrays.asList(TypeDescriptor.NOTYPE.impl, TypeDescriptor.NULL.impl, TypeDescriptor.BOOLEAN.impl, TypeDescriptor.NUMBER.impl, TypeDescriptor.STRING.impl, TypeDescriptor.HOST_OBJECT.impl, TypeDescriptor.NATIVE_POINTER.impl, TypeDescriptor.OBJECT.impl, TypeDescriptor.ARRAY.impl, TypeDescriptor.EXECUTABLE_ANY.impl))));
    private static final TypeDescriptor[] PREDEFINED_TYPES = new TypeDescriptor[]{NOTYPE, NULL, BOOLEAN, NUMBER, STRING, HOST_OBJECT, NATIVE_POINTER, OBJECT, ARRAY, EXECUTABLE, EXECUTABLE_ANY, ANY};
    private final TypeDescriptorImpl impl;

    private TypeDescriptor(TypeDescriptorImpl impl) {
        Objects.requireNonNull(impl);
        this.impl = impl;
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != TypeDescriptor.class) {
            return false;
        }
        return this.impl.equals(((TypeDescriptor)obj).impl);
    }

    public String toString() {
        return this.impl.toString();
    }

    public boolean isAssignable(TypeDescriptor fromType) {
        return this.impl.isAssignable(this.impl, fromType.impl);
    }

    public boolean isUnion() {
        return this.impl.getClass() == UnionImpl.class;
    }

    public boolean isIntersection() {
        return this.impl.getClass() == IntersectionImpl.class;
    }

    public static TypeDescriptor union(TypeDescriptor ... types) {
        Objects.requireNonNull(types);
        HashSet typesSet = new HashSet();
        Collections.addAll(typesSet, types);
        switch (typesSet.size()) {
            case 0: {
                throw new IllegalArgumentException("No types.");
            }
            case 1: {
                return types[0];
            }
        }
        HashSet<TypeDescriptorImpl> typeImpls = new HashSet<TypeDescriptorImpl>();
        for (TypeDescriptor type : typesSet) {
            typeImpls.add(type.impl);
        }
        TypeDescriptorImpl unionImpl = TypeDescriptor.unionImpl(typeImpls);
        TypeDescriptor result = TypeDescriptor.isPredefined(unionImpl);
        return result != null ? result : new TypeDescriptor(unionImpl);
    }

    private static TypeDescriptorImpl unionImpl(Collection<? extends TypeDescriptorImpl> typeImpls) {
        HashSet<TypeDescriptorImpl> subtypes = new HashSet<TypeDescriptorImpl>();
        for (TypeDescriptorImpl typeDescriptorImpl : typeImpls) {
            if (typeDescriptorImpl.getClass() == UnionImpl.class) {
                subtypes.addAll(((UnionImpl)typeDescriptorImpl).types);
                continue;
            }
            subtypes.add(typeDescriptorImpl);
        }
        HashSet<TypeDescriptorImpl> impls = new HashSet<TypeDescriptorImpl>();
        HashSet<ArrayImpl> hashSet = new HashSet<ArrayImpl>();
        for (TypeDescriptorImpl part : subtypes) {
            if (part instanceof ArrayImpl) {
                hashSet.add((ArrayImpl)part);
                continue;
            }
            impls.add(part);
        }
        switch (hashSet.size()) {
            case 0: {
                break;
            }
            case 1: {
                impls.add((TypeDescriptorImpl)hashSet.iterator().next());
                break;
            }
            default: {
                boolean seenWildCard = false;
                HashSet<TypeDescriptorImpl> contentTypes = new HashSet<TypeDescriptorImpl>();
                for (ArrayImpl array : hashSet) {
                    TypeDescriptorImpl contentType = array.contentType;
                    if (contentType == null || TypeDescriptor.isAny(contentType)) {
                        seenWildCard = true;
                        break;
                    }
                    contentTypes.add(contentType);
                }
                TypeDescriptorImpl contentType = TypeDescriptor.unionImpl(contentTypes);
                impls.add(seenWildCard ? TypeDescriptor.ARRAY.impl : new ArrayImpl(TypeDescriptor.isAny(contentType) ? null : contentType));
            }
        }
        return impls.size() == 1 ? (TypeDescriptorImpl)impls.iterator().next() : new UnionImpl(impls);
    }

    public static TypeDescriptor intersection(TypeDescriptor ... types) {
        Objects.requireNonNull(types);
        HashSet typesSet = new HashSet();
        Collections.addAll(typesSet, types);
        switch (typesSet.size()) {
            case 0: {
                return NOTYPE;
            }
            case 1: {
                return types[0];
            }
        }
        HashSet<TypeDescriptorImpl> typeImpls = new HashSet<TypeDescriptorImpl>();
        for (TypeDescriptor type : typesSet) {
            typeImpls.add(type.impl);
        }
        TypeDescriptorImpl intersectionImpl = TypeDescriptor.intersectionImpl(typeImpls);
        TypeDescriptor result = TypeDescriptor.isPredefined(intersectionImpl);
        return result != null ? result : new TypeDescriptor(intersectionImpl);
    }

    private static TypeDescriptorImpl intersectionImpl(Collection<? extends TypeDescriptorImpl> typeImpls) {
        HashSet<UnionImpl> unions = new HashSet<UnionImpl>();
        HashSet<TypeDescriptorImpl> nonUnionCompoments = new HashSet<TypeDescriptorImpl>();
        for (TypeDescriptorImpl typeDescriptorImpl : typeImpls) {
            if (typeDescriptorImpl.getClass() == UnionImpl.class) {
                unions.add((UnionImpl)typeDescriptorImpl);
                continue;
            }
            if (typeDescriptorImpl.getClass() == IntersectionImpl.class) {
                nonUnionCompoments.addAll(((IntersectionImpl)typeDescriptorImpl).types);
                continue;
            }
            nonUnionCompoments.add(typeDescriptorImpl);
        }
        HashSet dnfComponents = new HashSet();
        TypeDescriptorImpl[][] typeDescriptorImplArray = new TypeDescriptorImpl[unions.size()][];
        Iterator it = unions.iterator();
        int i = 0;
        while (it.hasNext()) {
            UnionImpl union = (UnionImpl)it.next();
            typeDescriptorImplArray[i] = union.types.toArray(new TypeDescriptorImpl[union.types.size()]);
            ++i;
        }
        TypeDescriptor.collectDNFComponents(typeDescriptorImplArray, nonUnionCompoments, new int[unions.size()], 0, dnfComponents);
        return dnfComponents.size() == 1 ? (TypeDescriptorImpl)dnfComponents.iterator().next() : TypeDescriptor.unionImpl(dnfComponents);
    }

    private static void collectDNFComponents(TypeDescriptorImpl[][] unionTypes, Collection<? extends TypeDescriptorImpl> tail, int[] indexes, int currentIndex, Collection<? super TypeDescriptorImpl> collector) {
        if (currentIndex == indexes.length) {
            HashSet<TypeDescriptorImpl> currentComponent = new HashSet<TypeDescriptorImpl>();
            boolean wca = false;
            boolean wce = false;
            for (int i = 0; i < unionTypes.length; ++i) {
                TypeDescriptorImpl typeDescriptorImpl = unionTypes[i][indexes[i]];
                if (typeDescriptorImpl.equals(TypeDescriptor.ARRAY.impl)) {
                    wca = true;
                }
                if (typeDescriptorImpl.equals(TypeDescriptor.EXECUTABLE.impl)) {
                    wce = true;
                }
                currentComponent.add(typeDescriptorImpl);
            }
            for (TypeDescriptorImpl typeDescriptorImpl : tail) {
                if (typeDescriptorImpl.equals(TypeDescriptor.ARRAY.impl)) {
                    wca = true;
                }
                if (typeDescriptorImpl.equals(TypeDescriptor.EXECUTABLE.impl)) {
                    wce = true;
                }
                currentComponent.add(typeDescriptorImpl);
            }
            if (wca || wce) {
                Iterator it = currentComponent.iterator();
                while (it.hasNext()) {
                    TypeDescriptorImpl typeDescriptorImpl = (TypeDescriptorImpl)it.next();
                    if (wca && typeDescriptorImpl.getClass() == ArrayImpl.class && typeDescriptorImpl != TypeDescriptor.ARRAY.impl) {
                        it.remove();
                        continue;
                    }
                    if (!wce || typeDescriptorImpl.getClass() != ExecutableImpl.class || typeDescriptorImpl == TypeDescriptor.EXECUTABLE.impl) continue;
                    it.remove();
                }
            }
            collector.add((TypeDescriptorImpl)(currentComponent.size() == 1 ? currentComponent.iterator().next() : new IntersectionImpl(currentComponent)));
        } else {
            int i = 0;
            while (i < unionTypes[currentIndex].length) {
                indexes[currentIndex] = i++;
                TypeDescriptor.collectDNFComponents(unionTypes, tail, indexes, currentIndex + 1, collector);
            }
        }
    }

    private static boolean isAny(TypeDescriptorImpl type) {
        return type.isAssignable(type, TypeDescriptor.ANY.impl);
    }

    public static TypeDescriptor array(TypeDescriptor componentType) {
        Objects.requireNonNull(componentType, "Component type canot be null");
        return TypeDescriptor.isAny(componentType.impl) ? ARRAY : new TypeDescriptor(new ArrayImpl(componentType.impl));
    }

    public static TypeDescriptor executable(TypeDescriptor returnType, TypeDescriptor ... parameterTypes) {
        return TypeDescriptor.executable(returnType, true, parameterTypes);
    }

    public static TypeDescriptor executable(TypeDescriptor returnType, boolean vararg, TypeDescriptor ... parameterTypes) {
        Objects.requireNonNull(returnType, "Return type cannot be null");
        Objects.requireNonNull(parameterTypes, "Parameter types cannot be null");
        if (TypeDescriptor.isAny(returnType.impl) && parameterTypes.length == 0 && vararg) {
            return EXECUTABLE;
        }
        ArrayList<TypeDescriptorImpl> paramTypeImpls = new ArrayList<TypeDescriptorImpl>(parameterTypes.length);
        for (TypeDescriptor td : parameterTypes) {
            Objects.requireNonNull(td, "Parameter types cannot contain null");
            paramTypeImpls.add(td.impl);
        }
        return new TypeDescriptor(new ExecutableImpl(ExecutableImpl.Kind.UNIT, TypeDescriptor.isAny(returnType.impl) ? null : returnType.impl, vararg, paramTypeImpls));
    }

    public static TypeDescriptor forValue(Value value) {
        ArrayList<TypeDescriptor> descs = new ArrayList<TypeDescriptor>();
        if (value.isNull()) {
            descs.add(NULL);
        }
        if (value.isBoolean()) {
            descs.add(BOOLEAN);
        }
        if (value.isNumber()) {
            descs.add(NUMBER);
        }
        if (value.isString()) {
            descs.add(STRING);
        }
        if (value.isNativePointer()) {
            descs.add(NATIVE_POINTER);
        }
        if (value.hasArrayElements()) {
            HashSet<TypeDescriptor> contentTypes = new HashSet<TypeDescriptor>();
            int i = 0;
            while ((long)i < value.getArraySize()) {
                TypeDescriptor contentType = TypeDescriptor.forValue(value.getArrayElement((long)i));
                if (contentType != NULL) {
                    contentTypes.add(contentType);
                }
                ++i;
            }
            switch (contentTypes.size()) {
                case 0: {
                    descs.add(TypeDescriptor.intersection(NOTYPE, NULL, BOOLEAN, NUMBER, STRING, HOST_OBJECT, NATIVE_POINTER, OBJECT, ARRAY, EXECUTABLE));
                    break;
                }
                case 1: {
                    descs.add(TypeDescriptor.array((TypeDescriptor)contentTypes.iterator().next()));
                    break;
                }
                default: {
                    descs.add(TypeDescriptor.array(TypeDescriptor.union(contentTypes.toArray(new TypeDescriptor[contentTypes.size()]))));
                }
            }
        }
        if (value.hasMembers()) {
            descs.add(OBJECT);
        }
        if (value.isHostObject()) {
            descs.add(HOST_OBJECT);
        }
        if (value.canExecute()) {
            descs.add(EXECUTABLE);
        }
        switch (descs.size()) {
            case 1: {
                return (TypeDescriptor)descs.get(0);
            }
        }
        return TypeDescriptor.intersection(descs.toArray(new TypeDescriptor[descs.size()]));
    }

    private static TypeDescriptor isPredefined(TypeDescriptorImpl impl) {
        for (TypeDescriptor predef : PREDEFINED_TYPES) {
            if (impl != predef.impl) continue;
            return predef;
        }
        return null;
    }

    private static final class UnionImpl
    extends TypeDescriptorImpl {
        private final Set<TypeDescriptorImpl> types;

        private UnionImpl(Set<TypeDescriptorImpl> types) {
            this.types = Collections.unmodifiableSet(types);
        }

        @Override
        boolean isAssignable(TypeDescriptorImpl origType, TypeDescriptorImpl byType) {
            TypeDescriptorImpl other = this.other(origType, byType);
            Class<?> otherClz = other.getClass();
            if (otherClz == PrimitiveImpl.class || otherClz == ArrayImpl.class || otherClz == ExecutableImpl.class) {
                if (other == byType) {
                    for (TypeDescriptorImpl type : this.types) {
                        if (!type.isAssignable(type, other)) continue;
                        return true;
                    }
                }
                return false;
            }
            if (otherClz == IntersectionImpl.class) {
                if (other == byType) {
                    UnionImpl origUnion = (UnionImpl)origType;
                    for (TypeDescriptorImpl unionSubType : origUnion.types) {
                        if (!unionSubType.isAssignable(unionSubType, byType)) continue;
                        return true;
                    }
                    return false;
                }
                UnionImpl byUnion = (UnionImpl)byType;
                for (TypeDescriptorImpl unionSubType : byUnion.types) {
                    if (origType.isAssignable(origType, unionSubType)) continue;
                    return false;
                }
                return true;
            }
            if (otherClz == UnionImpl.class) {
                UnionImpl origUnion = (UnionImpl)origType;
                UnionImpl byUnion = (UnionImpl)byType;
                HashSet<TypeDescriptorImpl> copy = new HashSet<TypeDescriptorImpl>(byUnion.types.size());
                block3: for (TypeDescriptorImpl type : byUnion.types) {
                    if (origUnion.types.contains(type)) {
                        copy.add(type);
                        continue;
                    }
                    if (type.getClass() != ArrayImpl.class && type.getClass() != ExecutableImpl.class && type.getClass() != IntersectionImpl.class) continue;
                    for (TypeDescriptorImpl filteredType : origUnion.types) {
                        if (!filteredType.isAssignable(filteredType, type)) continue;
                        copy.add(type);
                        continue block3;
                    }
                }
                return byUnion.types.equals(copy);
            }
            return other.isAssignable(origType, byType);
        }

        public int hashCode() {
            return this.types.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != UnionImpl.class) {
                return false;
            }
            return this.types.equals(((UnionImpl)obj).types);
        }

        public String toString() {
            return this.types.stream().map(Object::toString).collect(Collectors.joining(" | ", "[", "]"));
        }
    }

    private static final class IntersectionImpl
    extends TypeDescriptorImpl {
        private final Set<TypeDescriptorImpl> types;

        IntersectionImpl(Set<TypeDescriptorImpl> types) {
            this.types = Collections.unmodifiableSet(types);
        }

        @Override
        boolean isAssignable(TypeDescriptorImpl origType, TypeDescriptorImpl byType) {
            TypeDescriptorImpl other = this.other(origType, byType);
            Class<?> otherClz = other.getClass();
            if (otherClz == PrimitiveImpl.class || otherClz == ArrayImpl.class || otherClz == ExecutableImpl.class) {
                if (other == origType) {
                    for (TypeDescriptorImpl type : this.types) {
                        if (!other.isAssignable(other, type)) continue;
                        return true;
                    }
                    return false;
                }
                if (this.types.isEmpty()) {
                    return false;
                }
                for (TypeDescriptorImpl type : this.types) {
                    if (type.isAssignable(type, other)) continue;
                    return false;
                }
                return true;
            }
            if (otherClz == IntersectionImpl.class) {
                IntersectionImpl origIntersection = (IntersectionImpl)origType;
                IntersectionImpl byIntersection = (IntersectionImpl)byType;
                if (origIntersection.types.isEmpty()) {
                    return byIntersection.types.isEmpty();
                }
                for (TypeDescriptorImpl subType : origIntersection.types) {
                    boolean included;
                    if (byIntersection.types.contains(subType)) continue;
                    if (subType.getClass() == ArrayImpl.class) {
                        included = false;
                        for (TypeDescriptorImpl bySubType : byIntersection.types) {
                            if (bySubType.getClass() != ArrayImpl.class || !subType.isAssignable(subType, bySubType)) continue;
                            included = true;
                            break;
                        }
                        if (included) continue;
                        return false;
                    }
                    if (subType.getClass() == ExecutableImpl.class) {
                        included = false;
                        for (TypeDescriptorImpl bySubType : byIntersection.types) {
                            if (bySubType.getClass() != ExecutableImpl.class || !subType.isAssignable(subType, bySubType)) continue;
                            included = true;
                            break;
                        }
                        if (included) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
            return other.isAssignable(origType, byType);
        }

        public int hashCode() {
            return this.types.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != IntersectionImpl.class) {
                return false;
            }
            return this.types.equals(((IntersectionImpl)obj).types);
        }

        public String toString() {
            return this.types.isEmpty() ? "<none>" : this.types.stream().map(Object::toString).collect(Collectors.joining(" & ", "[", "]"));
        }
    }

    private static final class ArrayImpl
    extends TypeDescriptorImpl {
        private final TypeDescriptorImpl contentType;

        ArrayImpl(TypeDescriptorImpl contentType) {
            this.contentType = contentType;
        }

        @Override
        boolean isAssignable(TypeDescriptorImpl origType, TypeDescriptorImpl byType) {
            TypeDescriptorImpl other = this.other(origType, byType);
            Class<?> otherClz = other.getClass();
            if (otherClz == PrimitiveImpl.class || otherClz == ExecutableImpl.class) {
                return false;
            }
            if (otherClz == ArrayImpl.class) {
                ArrayImpl origArray = (ArrayImpl)origType;
                ArrayImpl byArray = (ArrayImpl)byType;
                return origArray.resolveContentType().isAssignable(origArray.resolveContentType(), byArray.resolveContentType());
            }
            return other.isAssignable(origType, byType);
        }

        public int hashCode() {
            return this.contentType != null ? this.contentType.hashCode() : 0;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ArrayImpl.class) {
                return false;
            }
            return Objects.equals(this.contentType, ((ArrayImpl)obj).contentType);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Array<");
            if (this.contentType == null) {
                sb.append("<any>");
            } else {
                sb.append(this.contentType.toString());
            }
            sb.append(">");
            return sb.toString();
        }

        private TypeDescriptorImpl resolveContentType() {
            return this.contentType != null ? this.contentType : ANY.impl;
        }
    }

    private static final class ExecutableImpl
    extends TypeDescriptorImpl {
        private final Kind kind;
        private final TypeDescriptorImpl retType;
        private final boolean vararg;
        private final List<? extends TypeDescriptorImpl> paramTypes;

        ExecutableImpl(Kind kind, TypeDescriptorImpl retType, boolean vararg, List<? extends TypeDescriptorImpl> paramTypes) {
            assert (kind != null);
            assert (paramTypes != null);
            assert (kind == Kind.UNIT || retType == null && paramTypes.isEmpty());
            this.kind = kind;
            this.retType = retType;
            this.vararg = vararg;
            this.paramTypes = paramTypes;
        }

        @Override
        boolean isAssignable(TypeDescriptorImpl origType, TypeDescriptorImpl byType) {
            TypeDescriptorImpl other = this.other(origType, byType);
            Class<?> otherClz = other.getClass();
            if (otherClz == PrimitiveImpl.class) {
                return false;
            }
            if (otherClz == ExecutableImpl.class) {
                ExecutableImpl origExec = (ExecutableImpl)origType;
                ExecutableImpl byExec = (ExecutableImpl)byType;
                if (origExec.kind == Kind.TOP) {
                    return true;
                }
                if (byExec.kind == Kind.TOP) {
                    return false;
                }
                if (!origExec.resolveRetType().isAssignable(origExec.resolveRetType(), byExec.resolveRetType())) {
                    return false;
                }
                if (origExec.paramTypes.size() < byExec.paramTypes.size()) {
                    return false;
                }
                if (!byExec.vararg && origExec.paramTypes.size() != byExec.paramTypes.size()) {
                    return false;
                }
                for (int i = 0; i < byExec.paramTypes.size(); ++i) {
                    TypeDescriptorImpl pt = origExec.paramTypes.get(i);
                    TypeDescriptorImpl opt = byExec.paramTypes.get(i);
                    if (opt.isAssignable(opt, pt)) continue;
                    return false;
                }
                return true;
            }
            return other.isAssignable(origType, byType);
        }

        public int hashCode() {
            int res = 17;
            res = res * 31 + (this.vararg ? 1 : 0);
            res = res * 31 + this.kind.hashCode();
            res = res * 31 + (this.retType == null ? 0 : this.retType.hashCode());
            for (TypeDescriptorImpl typeDescriptorImpl : this.paramTypes) {
                res = res * 31 + typeDescriptorImpl.hashCode();
            }
            return res;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ExecutableImpl.class) {
                return false;
            }
            ExecutableImpl other = (ExecutableImpl)obj;
            return this.vararg == other.vararg && this.kind == other.kind && Objects.equals(this.retType, other.retType) && this.paramTypes.equals(other.paramTypes);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Executable(");
            switch (this.kind) {
                case TOP: {
                    sb.append("? extends");
                    break;
                }
                case BOTTOM: {
                    sb.append("? super");
                    break;
                }
                case UNIT: {
                    boolean first = true;
                    for (TypeDescriptorImpl typeDescriptorImpl : this.paramTypes) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(", ");
                        }
                        sb.append(typeDescriptorImpl);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown kind: " + (Object)((Object)this.kind));
                }
            }
            if (this.vararg) {
                sb.append(", *");
            }
            sb.append("):");
            sb.append(this.retType == null ? "<any>" : this.retType);
            return sb.toString();
        }

        private TypeDescriptorImpl resolveRetType() {
            return this.retType != null ? this.retType : ANY.impl;
        }

        static enum Kind {
            TOP,
            BOTTOM,
            UNIT;

        }
    }

    private static final class PrimitiveImpl
    extends TypeDescriptorImpl {
        private final PrimitiveKind kind;

        PrimitiveImpl(PrimitiveKind kind) {
            Objects.requireNonNull(kind);
            this.kind = kind;
        }

        @Override
        boolean isAssignable(TypeDescriptorImpl origType, TypeDescriptorImpl byType) {
            TypeDescriptorImpl other = this.other(origType, byType);
            if (other.getClass() == PrimitiveImpl.class) {
                return this.kind == ((PrimitiveImpl)other).kind;
            }
            return other.isAssignable(origType, byType);
        }

        public int hashCode() {
            return this.kind.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != PrimitiveImpl.class) {
                return false;
            }
            return this.kind == ((PrimitiveImpl)obj).kind;
        }

        public String toString() {
            return this.kind.getDisplayName();
        }
    }

    private static abstract class TypeDescriptorImpl {
        private TypeDescriptorImpl() {
        }

        abstract boolean isAssignable(TypeDescriptorImpl var1, TypeDescriptorImpl var2);

        TypeDescriptorImpl other(TypeDescriptorImpl td1, TypeDescriptorImpl td2) {
            if (td1 == this) {
                return td2;
            }
            if (td2 == this) {
                return td1;
            }
            throw new IllegalArgumentException();
        }
    }

    private static enum PrimitiveKind {
        NULL("null"),
        BOOLEAN("boolean"),
        NUMBER("number"),
        STRING("string"),
        HOST_OBJECT("hostObject"),
        NATIVE_POINTER("nativePointer"),
        OBJECT("object");

        private final String displayName;

        private PrimitiveKind(String displayName) {
            this.displayName = displayName;
        }

        String getDisplayName() {
            return this.displayName;
        }
    }
}

