/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby;

import com.oracle.truffle.api.TruffleFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jcodings.Encoding;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.EncodingManager;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.parser.lexer.RubyLexer;

public final class RubyFileTypeDetector
implements TruffleFile.FileTypeDetector {
    private static final String[] KNOWN_RUBY_FILES = new String[]{"Gemfile", "Rakefile"};
    private static final String[] KNOWN_RUBY_SUFFIXES = new String[]{".rb", ".rake", ".gemspec"};
    private static final Pattern SHEBANG_REGEXP = Pattern.compile("^#! ?/usr/bin/(env +ruby|ruby).*");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String findMimeType(TruffleFile file) throws IOException {
        String fileName = file.getName();
        if (fileName == null) {
            return null;
        }
        String lowerCaseFileName = fileName.toLowerCase(Locale.ROOT);
        for (String candidate : KNOWN_RUBY_SUFFIXES) {
            if (!lowerCaseFileName.endsWith(candidate)) continue;
            return RubyLanguage.getMimeType(false);
        }
        for (String candidate : KNOWN_RUBY_FILES) {
            if (!fileName.equals(candidate)) continue;
            return RubyLanguage.getMimeType(false);
        }
        try (BufferedReader fileContent = file.newBufferedReader(StandardCharsets.UTF_8);){
            String firstLine = fileContent.readLine();
            if (firstLine == null) return null;
            if (!SHEBANG_REGEXP.matcher(firstLine).matches()) return null;
            String string = RubyLanguage.getMimeType(false);
            return string;
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Charset findEncoding(TruffleFile file) throws IOException {
        try (BufferedReader fileContent = file.newBufferedReader(StandardCharsets.UTF_8);){
            String firstLine = fileContent.readLine();
            if (firstLine == null) return null;
            String encodingCommentLine = SHEBANG_REGEXP.matcher(firstLine).matches() ? fileContent.readLine() : firstLine;
            if (encodingCommentLine == null) return null;
            TStringWithEncoding encodingComment = new TStringWithEncoding(TStringUtils.utf8TString(encodingCommentLine), Encodings.UTF_8);
            Charset[] encodingHolder = new Charset[1];
            RubyLexer.parseMagicComment(encodingComment, (name, value) -> {
                Encoding encoding;
                if (RubyLexer.isMagicEncodingComment(name) && (encoding = EncodingManager.getEncoding(value)) != null) {
                    encodingHolder[0] = encoding.getCharset();
                }
            });
            Charset charset = encodingHolder[0];
            return charset;
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        return null;
    }
}

