/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;
import java.util.function.Function;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Split;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.BuiltinsClasses;
import org.truffleruby.builtins.EnumeratorSizeNode;
import org.truffleruby.builtins.ReRaiseInlinedExceptionNode;
import org.truffleruby.builtins.ReturnEnumeratorIfNoBlockNode;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.DummyNode;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.inlined.AlwaysInlinedMethodNode;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.ConstantLookupResult;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.numeric.FixnumLowerNodeGen;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.support.TypeNodes;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyCoreMethodRootNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.arguments.MissingArgumentBehavior;
import org.truffleruby.language.arguments.ReadBlockFromCurrentFrameArgumentsNode;
import org.truffleruby.language.arguments.ReadPreArgumentNode;
import org.truffleruby.language.arguments.ReadRemainingArgumentsNode;
import org.truffleruby.language.arguments.ReadSelfNode;
import org.truffleruby.language.control.ReturnID;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.CachedLazyCallTargetSupplier;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.objects.SingletonClassNode;
import org.truffleruby.parser.Translator;

public final class CoreMethodNodeManager {
    private final RubyContext context;
    private final RubyLanguage language;

    public CoreMethodNodeManager(RubyContext context) {
        this.context = context;
        this.language = context.getLanguageSlow();
    }

    public void loadCoreMethodNodes() {
        if (!TruffleOptions.AOT && this.language.options.LAZY_BUILTINS) {
            BuiltinsClasses.setupBuiltinsLazy(this);
        } else {
            for (List<? extends NodeFactory<? extends RubyBaseNode>> factory : BuiltinsClasses.getCoreNodeFactories()) {
                this.addCoreMethodNodes(factory);
            }
        }
    }

    public void addCoreMethodNodes(List<? extends NodeFactory<? extends RubyBaseNode>> nodeFactories) {
        String moduleName = null;
        RubyModule module = null;
        for (NodeFactory<? extends RubyBaseNode> nodeFactory : nodeFactories) {
            Class nodeClass = nodeFactory.getNodeClass();
            CoreMethod methodAnnotation = nodeClass.getAnnotation(CoreMethod.class);
            if (methodAnnotation == null) continue;
            if (module == null) {
                CoreModule coreModule = nodeClass.getEnclosingClass().getAnnotation(CoreModule.class);
                if (coreModule == null) {
                    throw new Error(nodeClass.getEnclosingClass() + " needs a @CoreModule annotation");
                }
                moduleName = coreModule.value();
                module = this.getModule(moduleName, coreModule.isClass());
            }
            this.addCoreMethod(module, new MethodDetails(moduleName, methodAnnotation, nodeFactory));
        }
    }

    private RubyModule getModule(String fullName, boolean isClass) {
        RubyModule module;
        if (fullName.equals("main")) {
            module = this.getSingletonClass((Object)this.context.getCoreLibrary().mainObject);
        } else {
            module = this.context.getCoreLibrary().objectClass;
            for (String moduleName : fullName.split("::")) {
                ConstantLookupResult constant = ModuleOperations.lookupConstant(this.context, module, moduleName);
                if (!constant.isFound()) {
                    throw new RuntimeException(StringUtils.format("Module %s not found when adding core library", moduleName));
                }
                module = (RubyModule)constant.getConstant().getValue();
            }
        }
        assert (isClass == module instanceof RubyClass) : fullName;
        return module;
    }

    private RubyClass getSingletonClass(Object object) {
        return SingletonClassNode.getUncached().execute(object);
    }

    private Split effectiveSplit(Split split, boolean needsBlock) {
        if (this.context.getOptions().CORE_ALWAYS_CLONE) {
            return Split.ALWAYS;
        }
        if (split == Split.DEFAULT) {
            return needsBlock ? Split.ALWAYS : Split.HEURISTIC;
        }
        return split;
    }

    private void addCoreMethod(RubyModule module, MethodDetails methodDetails) {
        CoreMethod annotation = methodDetails.getMethodAnnotation();
        String[] names = annotation.names();
        assert (names.length >= 1);
        Visibility visibility = annotation.visibility();
        this.verifyUsage(module, methodDetails, annotation, visibility);
        Arity arity = new Arity(annotation.required(), annotation.optional(), annotation.rest());
        NodeFactory<? extends RubyBaseNode> nodeFactory = methodDetails.getNodeFactory();
        boolean onSingleton = annotation.onSingleton() || annotation.constructor();
        boolean isModuleFunc = annotation.isModuleFunction();
        Split split = this.effectiveSplit(annotation.split(), annotation.needsBlock());
        Function<SharedMethodInfo, RootCallTarget> callTargetFactory = sharedMethodInfo -> CoreMethodNodeManager.createCoreMethodCallTarget(nodeFactory, this.language, sharedMethodInfo, split, annotation);
        this.addMethods(module, methodDetails.moduleName, isModuleFunc, onSingleton, annotation.alwaysInlined(), names, arity, visibility, callTargetFactory);
    }

    public void addLazyCoreMethod(String nodeFactoryName, String moduleName, boolean isClass, Visibility visibility, boolean isModuleFunc, boolean onSingleton, boolean alwaysInlined, Split split, int required, int optional, boolean rest, boolean needsBlock, String ... names) {
        RubyModule module = this.getModule(moduleName, isClass);
        Arity arity = new Arity(required, optional, rest);
        Split finalSplit = alwaysInlined ? Split.NEVER : this.effectiveSplit(split, needsBlock);
        Function<SharedMethodInfo, RootCallTarget> callTargetFactory = sharedMethodInfo -> {
            NodeFactory<? extends RubyBaseNode> nodeFactory = CoreMethodNodeManager.loadNodeFactory(nodeFactoryName);
            CoreMethod annotation = nodeFactory.getNodeClass().getAnnotation(CoreMethod.class);
            return CoreMethodNodeManager.createCoreMethodCallTarget(nodeFactory, this.language, sharedMethodInfo, finalSplit, annotation);
        };
        this.addMethods(module, moduleName, isModuleFunc, onSingleton, alwaysInlined, names, arity, visibility, callTargetFactory);
    }

    private void addMethods(RubyModule module, String moduleName, boolean isModuleFunction, boolean onSingleton, boolean alwaysInlined, String[] names, Arity arity, Visibility visibility, Function<SharedMethodInfo, RootCallTarget> callTargetFactory) {
        if (isModuleFunction) {
            CoreMethodNodeManager.addMethod(this.context, module, moduleName, false, alwaysInlined, callTargetFactory, names, arity, Visibility.PRIVATE);
            RubyClass sclass = this.getSingletonClass(module);
            CoreMethodNodeManager.addMethod(this.context, sclass, moduleName, true, alwaysInlined, callTargetFactory, names, arity, Visibility.PUBLIC);
        } else if (onSingleton) {
            RubyClass sclass = this.getSingletonClass(module);
            CoreMethodNodeManager.addMethod(this.context, sclass, moduleName, true, alwaysInlined, callTargetFactory, names, arity, visibility);
        } else {
            CoreMethodNodeManager.addMethod(this.context, module, moduleName, false, alwaysInlined, callTargetFactory, names, arity, visibility);
        }
    }

    private static void addMethod(RubyContext context, RubyModule module, String moduleName, boolean onSingleton, boolean alwaysInlined, Function<SharedMethodInfo, RootCallTarget> callTargetFactory, String[] names, Arity arity, Visibility visibility) {
        TruffleSafepoint.poll((Node)DummyNode.INSTANCE);
        for (String name : names) {
            NodeFactory<? extends RubyBaseNode> alwaysInlinedNodeFactory;
            CachedLazyCallTargetSupplier callTargetSupplier;
            RootCallTarget callTarget;
            SharedMethodInfo sharedMethodInfo = CoreMethodNodeManager.makeSharedMethodInfo(moduleName, onSingleton, name, arity);
            if (alwaysInlined) {
                callTarget = callTargetFactory.apply(sharedMethodInfo);
                callTargetSupplier = null;
                alwaysInlinedNodeFactory = RubyRootNode.of(callTarget).getAlwaysInlinedNodeFactory();
            } else {
                if (context.getLanguageSlow().options.LAZY_CALLTARGETS) {
                    callTarget = null;
                    callTargetSupplier = new CachedLazyCallTargetSupplier(() -> (RootCallTarget)callTargetFactory.apply(sharedMethodInfo));
                } else {
                    callTarget = callTargetFactory.apply(sharedMethodInfo);
                    callTargetSupplier = null;
                }
                alwaysInlinedNodeFactory = null;
            }
            module.fields.addMethod(context, null, new InternalMethod(context, sharedMethodInfo, LexicalScope.IGNORE, DeclarationContext.NONE, name, module, ModuleOperations.isMethodPrivateFromName(name) ? Visibility.PRIVATE : visibility, false, alwaysInlinedNodeFactory, null, callTarget, callTargetSupplier));
        }
    }

    private static SharedMethodInfo makeSharedMethodInfo(String moduleName, boolean onSingleton, String name, Arity arity) {
        String parseName = onSingleton || moduleName.equals("main") ? moduleName + "." + name : moduleName + "#" + name;
        return new SharedMethodInfo(CoreLibrary.JAVA_CORE_SOURCE_SECTION, LexicalScope.IGNORE, arity, name, 0, parseName, "builtin", null);
    }

    public static RootCallTarget createCoreMethodCallTarget(NodeFactory<? extends RubyBaseNode> nodeFactory, RubyLanguage language, SharedMethodInfo sharedMethodInfo, Split split, CoreMethod method) {
        Class nodeClass = nodeFactory.getNodeClass();
        boolean alwaysInlinedSubclass = AlwaysInlinedMethodNode.class.isAssignableFrom(nodeClass);
        if (method.alwaysInlined() != alwaysInlinedSubclass) {
            throw new Error(nodeClass + " subclasses AlwaysInlinedMethodNode != using @CoreMethod(alwaysInlined = true)");
        }
        if (method.alwaysInlined()) {
            assert (nodeFactory.getUncachedInstance() != null) : nodeClass + " must use @GenerateUncached";
            assert (nodeFactory.getUncachedInstance() instanceof AlwaysInlinedMethodNode) : nodeClass + " must subclass AlwaysInlinedMethodNode";
            if (method.lowerFixnum().length > 0 || method.raiseIfFrozenSelf() || method.raiseIfNotMutableSelf() || method.returnsEnumeratorIfNoBlock() || !method.enumeratorSize().isEmpty() || method.split() != Split.DEFAULT) {
                throw new Error("Always-inlined methods do not support all @CoreMethod attributes for " + nodeClass);
            }
            RubyRootNode reRaiseRootNode = new RubyRootNode(language, sharedMethodInfo.getSourceSection(), null, sharedMethodInfo, new ReRaiseInlinedExceptionNode(nodeFactory), Split.NEVER, ReturnID.INVALID);
            return reRaiseRootNode.getCallTarget();
        }
        return CoreMethodNodeManager.createCoreMethodRootNode(nodeFactory, language, sharedMethodInfo, split, method).getCallTarget();
    }

    public static RubyCoreMethodRootNode createCoreMethodRootNode(NodeFactory<? extends RubyBaseNode> nodeFactory, RubyLanguage language, SharedMethodInfo sharedMethodInfo, Split split, CoreMethod method) {
        assert (!method.alwaysInlined());
        RubyNode[] argumentsNodes = new RubyNode[nodeFactory.getExecutionSignature().size()];
        int i = 0;
        boolean needsSelf = CoreMethodNodeManager.needsSelf(method);
        if (needsSelf) {
            RubyNode readSelfNode = Translator.profileArgument(language, new ReadSelfNode());
            argumentsNodes[i++] = CoreMethodNodeManager.transformArgument(method, readSelfNode, 0);
        }
        int required = method.required();
        int optional = method.optional();
        int nArgs = required + optional;
        for (int n = 0; n < nArgs; ++n) {
            RubyNode readArgumentNode = Translator.profileArgument(language, new ReadPreArgumentNode(n, false, MissingArgumentBehavior.NOT_PROVIDED));
            argumentsNodes[i++] = CoreMethodNodeManager.transformArgument(method, readArgumentNode, n + 1);
        }
        if (method.rest()) {
            argumentsNodes[i++] = new ReadRemainingArgumentsNode(nArgs);
        }
        if (method.needsBlock()) {
            argumentsNodes[i++] = new ReadBlockFromCurrentFrameArgumentsNode();
        }
        RubyNode node = (RubyNode)CoreMethodNodeManager.createNodeFromFactory(nodeFactory, argumentsNodes);
        RubyNode methodNode = CoreMethodNodeManager.transformResult(language, method, node);
        return new RubyCoreMethodRootNode(language, sharedMethodInfo.getSourceSection(), null, sharedMethodInfo, methodNode, split, ReturnID.INVALID, sharedMethodInfo.getArity(), nodeFactory, method);
    }

    public static RubyBaseNode createNodeFromFactory(NodeFactory<? extends RubyBaseNode> nodeFactory, RubyNode[] argumentsNodes) {
        List signatures = nodeFactory.getNodeSignatures();
        assert (signatures.size() == 1);
        List signature = (List)signatures.get(0);
        if (signature.size() == 0) {
            return (RubyBaseNode)((Object)nodeFactory.createNode(new Object[0]));
        }
        if (signature.size() == 1 && signature.get(0) == RubyNode[].class) {
            RubyNode[] args = argumentsNodes;
            return (RubyBaseNode)((Object)nodeFactory.createNode(new Object[]{args}));
        }
        RubyNode[] args = argumentsNodes;
        return (RubyBaseNode)((Object)nodeFactory.createNode((Object[])args));
    }

    public static boolean needsSelf(CoreMethod method) {
        return method.constructor() || !method.isModuleFunction() && !method.onSingleton() && method.needsSelf();
    }

    private static RubyNode transformArgument(CoreMethod method, RubyNode argument, int n) {
        if (ArrayUtils.contains(method.lowerFixnum(), n)) {
            argument = FixnumLowerNodeGen.FixnumLowerASTNodeGen.create(argument);
        }
        if (n == 0 && method.raiseIfFrozenSelf()) {
            argument = TypeNodes.TypeCheckFrozenNode.create(argument);
        } else if (n == 0 && method.raiseIfNotMutableSelf()) {
            argument = TypeNodes.CheckMutableStringNode.create(argument);
        }
        return argument;
    }

    private static RubyNode transformResult(RubyLanguage language, CoreMethod method, RubyNode node) {
        if (!method.enumeratorSize().isEmpty()) {
            assert (!method.returnsEnumeratorIfNoBlock()) : "Only one of enumeratorSize or returnsEnumeratorIfNoBlock can be specified";
            node = new EnumeratorSizeNode(language.getSymbol(method.enumeratorSize()), language.getSymbol(method.names()[0]), node);
        } else if (method.returnsEnumeratorIfNoBlock()) {
            node = new ReturnEnumeratorIfNoBlockNode(method.names()[0], node);
        }
        return node;
    }

    private void verifyUsage(RubyModule module, MethodDetails methodDetails, CoreMethod method, Visibility visibility) {
        if (method.isModuleFunction()) {
            if (visibility != Visibility.PUBLIC) {
                RubyLanguage.LOGGER.warning("visibility ignored when isModuleFunction in " + methodDetails.getIndicativeName());
            }
            if (method.onSingleton()) {
                RubyLanguage.LOGGER.warning("either onSingleton or isModuleFunction for " + methodDetails.getIndicativeName());
            }
            if (method.constructor()) {
                RubyLanguage.LOGGER.warning("either constructor or isModuleFunction for " + methodDetails.getIndicativeName());
            }
            if (module instanceof RubyClass) {
                RubyLanguage.LOGGER.warning("using isModuleFunction on a Class for " + methodDetails.getIndicativeName());
            }
        }
        if (method.onSingleton() && method.constructor()) {
            RubyLanguage.LOGGER.warning("either onSingleton or constructor for " + methodDetails.getIndicativeName());
        }
        if (methodDetails.getPrimaryName().equals("allocate") && !methodDetails.getModuleName().equals("Class")) {
            RubyLanguage.LOGGER.warning("do not define #allocate but #__allocate__ for " + methodDetails.getIndicativeName());
        }
        if (methodDetails.getPrimaryName().equals("__allocate__") && method.visibility() != Visibility.PRIVATE) {
            RubyLanguage.LOGGER.warning(methodDetails.getIndicativeName() + " should be private");
        }
    }

    public static NodeFactory<? extends RubyBaseNode> loadNodeFactory(String nodeFactoryName) {
        Object instance;
        try {
            Class<?> nodeFactoryClass = Class.forName(nodeFactoryName);
            instance = nodeFactoryClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
        return (NodeFactory)instance;
    }

    public static final class MethodDetails {
        private final String moduleName;
        private final CoreMethod methodAnnotation;
        private final NodeFactory<? extends RubyBaseNode> nodeFactory;

        public MethodDetails(String moduleName, CoreMethod methodAnnotation, NodeFactory<? extends RubyBaseNode> nodeFactory) {
            this.moduleName = moduleName;
            this.methodAnnotation = methodAnnotation;
            this.nodeFactory = nodeFactory;
        }

        public CoreMethod getMethodAnnotation() {
            return this.methodAnnotation;
        }

        public NodeFactory<? extends RubyBaseNode> getNodeFactory() {
            return this.nodeFactory;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public String getPrimaryName() {
            return this.methodAnnotation.names()[0];
        }

        public String getIndicativeName() {
            return this.moduleName + "#" + this.getPrimaryName();
        }
    }
}

