/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.cext;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.VarHandle;
import org.truffleruby.Layouts;
import org.truffleruby.cext.ValueWrapper;
import org.truffleruby.cext.WrapNodeGen;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.language.ImmutableRubyObject;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.control.RaiseException;

@GenerateUncached
public abstract class WrapNode
extends RubyBaseNode {
    @NeverDefault
    public static WrapNode create() {
        return WrapNodeGen.create();
    }

    public abstract ValueWrapper execute(Object var1);

    @Specialization
    ValueWrapper wrapLong(long value, @Cached @Cached.Exclusive InlinedBranchProfile smallFixnumProfile) {
        if (value >= -4611686018427387904L && value <= 0x3FFFFFFFFFFFFFFFL) {
            smallFixnumProfile.enter((Node)this);
            long val = value << 1 | 1L;
            return new ValueWrapper(null, val, null);
        }
        return this.getContext().getValueWrapperManager().longWrapper(value);
    }

    @Specialization
    ValueWrapper wrapDouble(double value) {
        return this.getContext().getValueWrapperManager().doubleWrapper(value);
    }

    @Specialization
    ValueWrapper wrapBoolean(boolean value) {
        return value ? this.getContext().getValueWrapperManager().trueWrapper : this.getContext().getValueWrapperManager().falseWrapper;
    }

    @Specialization
    ValueWrapper wrapUndef(NotProvided value) {
        return this.getContext().getValueWrapperManager().undefWrapper;
    }

    @Specialization
    ValueWrapper wrapWrappedValue(ValueWrapper value, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        RubyString message = this.createString(fromJavaStringNode, "Wrapping wrapped object", Encodings.UTF_8);
        throw new RaiseException(this.getContext(), this.coreExceptions().argumentError(message, (Node)this, null));
    }

    @Specialization
    ValueWrapper wrapNil(Nil value) {
        return value.getValueWrapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(guards={"!isNil(value)"})
    ValueWrapper wrapImmutable(ImmutableRubyObject value, @Cached @Cached.Shared InlinedBranchProfile noHandleProfile) {
        ValueWrapper wrapper = value.getValueWrapper();
        if (wrapper == null) {
            noHandleProfile.enter((Node)this);
            ImmutableRubyObject immutableRubyObject = value;
            synchronized (immutableRubyObject) {
                wrapper = value.getValueWrapper();
                if (wrapper == null) {
                    wrapper = new ValueWrapper(value, -2L, null);
                    VarHandle.storeStoreFence();
                    value.setValueWrapper(wrapper);
                }
            }
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(limit="getDynamicObjectCacheLimit()")
    static ValueWrapper wrapValue(RubyDynamicObject value, @CachedLibrary(value="value") DynamicObjectLibrary objectLibrary, @Cached @Cached.Shared InlinedBranchProfile noHandleProfile, @Bind(value="this") Node node) {
        ValueWrapper wrapper = (ValueWrapper)objectLibrary.getOrDefault((DynamicObject)value, (Object)Layouts.VALUE_WRAPPER_IDENTIFIER, null);
        if (wrapper == null) {
            noHandleProfile.enter(node);
            RubyDynamicObject rubyDynamicObject = value;
            synchronized (rubyDynamicObject) {
                wrapper = (ValueWrapper)objectLibrary.getOrDefault((DynamicObject)value, (Object)Layouts.VALUE_WRAPPER_IDENTIFIER, null);
                if (wrapper == null) {
                    wrapper = new ValueWrapper((Object)value, -2L, null);
                    VarHandle.storeStoreFence();
                    objectLibrary.put((DynamicObject)value, (Object)Layouts.VALUE_WRAPPER_IDENTIFIER, (Object)wrapper);
                }
            }
        }
        return wrapper;
    }

    @Specialization(guards={"isForeignObject(value)"})
    ValueWrapper wrapNonRubyObject(Object value) {
        throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("Attempt to wrap something that isn't an Ruby object", this));
    }
}

