/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.collections;

import com.oracle.truffle.api.CompilerDirectives;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentWeakKeysMap<Key, Value> {
    protected final ConcurrentHashMap<WeakKeyReference<Key>, Value> map = new ConcurrentHashMap();
    private final ReferenceQueue<Key> referenceQueue = new ReferenceQueue();

    @CompilerDirectives.TruffleBoundary
    public Value get(Key key) {
        this.removeStaleEntries();
        return this.map.get(new WeakKeyReference<Key>(key));
    }

    public boolean contains(Key key) {
        return this.get(key) != null;
    }

    @CompilerDirectives.TruffleBoundary
    public Value put(Key key, Value value) {
        this.removeStaleEntries();
        WeakKeyReference<Key> ref = new WeakKeyReference<Key>(key, this.referenceQueue);
        return this.map.put(ref, value);
    }

    @CompilerDirectives.TruffleBoundary
    public Collection<Key> keys() {
        this.removeStaleEntries();
        ArrayList keys = new ArrayList(this.map.size());
        for (WeakKeyReference e : this.map.keySet()) {
            Object key = e.get();
            if (key == null) continue;
            keys.add(key);
        }
        return keys;
    }

    private void removeStaleEntries() {
        WeakKeyReference ref;
        while ((ref = (WeakKeyReference)this.referenceQueue.poll()) != null) {
            this.map.remove(ref);
        }
    }

    protected static final class WeakKeyReference<Key>
    extends WeakReference<Key> {
        private final int hashCode;

        public WeakKeyReference(Key key) {
            super(key);
            Objects.requireNonNull(key);
            this.hashCode = key.hashCode();
        }

        public WeakKeyReference(Key key, ReferenceQueue<? super Key> queue) {
            super(key, queue);
            Objects.requireNonNull(key);
            this.hashCode = key.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof WeakKeyReference) {
                WeakKeyReference ref = (WeakKeyReference)other;
                Object key = this.get();
                Object otherKey = ref.get();
                return key != null && otherKey != null && key.equals(otherKey);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

