/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.cext.DataHolder;
import org.truffleruby.core.DataObjectFinalizerReference;
import org.truffleruby.core.MarkingService;
import org.truffleruby.core.ReferenceProcessingService;
import org.truffleruby.core.mutex.MutexOperations;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseRootNode;
import org.truffleruby.language.backtrace.InternalRootNode;

public final class DataObjectFinalizationService
extends ReferenceProcessingService<DataObjectFinalizerReference, Object> {
    private final CallTarget callTarget;

    public DataObjectFinalizationService(RubyLanguage language, ReferenceQueue<Object> processingQueue) {
        super(processingQueue);
        this.callTarget = new DataObjectFinalizerRootNode(language).getCallTarget();
    }

    public DataObjectFinalizationService(RubyLanguage language, ReferenceProcessingService.ReferenceProcessor referenceProcessor) {
        this(language, referenceProcessor.processingQueue);
    }

    public DataObjectFinalizerReference addFinalizer(RubyContext context, Object object, DataHolder dataHolder) {
        DataObjectFinalizerReference newRef = this.createRef(object, dataHolder);
        this.add(newRef);
        context.getReferenceProcessor().processReferenceQueue(this);
        return newRef;
    }

    public DataObjectFinalizerReference createRef(Object object, DataHolder dataHolder) {
        return new DataObjectFinalizerReference(object, this.processingQueue, this, dataHolder);
    }

    public final void drainFinalizationQueue(RubyContext context) {
        context.getReferenceProcessor().drainReferenceQueues();
    }

    @Override
    protected void processReference(RubyContext context, RubyLanguage language, ReferenceProcessingService.PhantomProcessingReference<?, ?> finalizerReference) {
        super.processReference(context, language, finalizerReference);
        this.runCatchingErrors(context, language, this::processReferenceInternal, (DataObjectFinalizerReference)finalizerReference);
    }

    @CompilerDirectives.TruffleBoundary
    protected void processReferenceInternal(RubyContext context, RubyLanguage language, DataObjectFinalizerReference ref) {
        this.callTarget.call(new Object[]{ref});
    }

    public static final class DataObjectFinalizerRootNode
    extends RubyBaseRootNode
    implements InternalRootNode {
        @Node.Child
        private InteropLibrary nullDataPointerNode;
        @Node.Child
        private InteropLibrary nullDataFreeNode;
        @Node.Child
        private InteropLibrary callNode;
        private final ConditionProfile ownedProfile = ConditionProfile.create();

        public DataObjectFinalizerRootNode(RubyLanguage language) {
            super(language, RubyLanguage.EMPTY_FRAME_DESCRIPTOR, null);
            this.nullDataPointerNode = (InteropLibrary)InteropLibrary.getFactory().createDispatched(1);
            this.nullDataFreeNode = (InteropLibrary)InteropLibrary.getFactory().createDispatched(1);
            this.callNode = (InteropLibrary)InteropLibrary.getFactory().createDispatched(1);
        }

        public Object execute(VirtualFrame frame) {
            return this.execute((DataObjectFinalizerReference)frame.getArguments()[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute(DataObjectFinalizerReference ref) {
            if (this.getContext().getOptions().CEXT_LOCK) {
                ReentrantLock lock = this.getContext().getCExtensionsLock();
                boolean owned = this.ownedProfile.profile(lock.isHeldByCurrentThread());
                if (!owned) {
                    MutexOperations.lockInternal(this.getContext(), lock, (Node)this);
                }
                try {
                    this.runFinalizer(ref);
                }
                finally {
                    if (!owned) {
                        MutexOperations.unlockInternal(lock);
                    }
                }
            } else {
                this.runFinalizer(ref);
            }
            return Nil.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runFinalizer(DataObjectFinalizerReference ref) throws Error {
            block5: {
                try {
                    if (this.getContext().isFinalizing()) break block5;
                    Object data = ref.dataHolder.getPointer();
                    Object callable = ref.dataHolder.getFree();
                    if (this.nullDataPointerNode.isNull(data) || this.nullDataFreeNode.isNull(callable)) break block5;
                    MarkingService.ExtensionCallStack stack = this.getLanguage().getCurrentFiber().extensionCallStack;
                    stack.push(false, stack.getSpecialVariables(), stack.getBlock());
                    try {
                        this.callNode.execute(callable, new Object[]{data});
                    }
                    finally {
                        stack.pop();
                    }
                }
                catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                    throw CompilerDirectives.shouldNotReachHere((String)"Data holder finalization on invalid object");
                }
            }
        }
    }
}

