/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import org.truffleruby.cext.CapturedException;
import org.truffleruby.cext.ValueWrapper;
import org.truffleruby.core.array.ArrayUtils;

public final class MarkingService {
    public void startMarking(ExtensionCallStack stack, Object[] oldMarks) {
        stack.current.marks = oldMarks == null ? ArrayUtils.EMPTY_ARRAY : oldMarks;
        stack.current.marksIndex = 0;
    }

    @CompilerDirectives.TruffleBoundary
    public void addMark(ExtensionCallStack stack, Object obj) {
        if (stack.current.marks.length == stack.current.marksIndex) {
            Object[] oldMarks = stack.current.marks;
            stack.current.marks = new Object[Integer.max(oldMarks.length * 2, 1)];
            System.arraycopy(oldMarks, 0, stack.current.marks, 0, oldMarks.length);
        }
        stack.current.marks[stack.current.marksIndex] = obj;
        ++stack.current.marksIndex;
    }

    @CompilerDirectives.TruffleBoundary
    public Object[] finishMarking(ExtensionCallStack stack) {
        if (stack.current.marksIndex != stack.current.marks.length) {
            for (int i = stack.current.marksIndex; i < stack.current.marks.length; ++i) {
                stack.current.marks[i] = null;
            }
        }
        Object[] result = stack.current.marks;
        stack.current.marks = null;
        return result;
    }

    public static final class ExtensionCallStack {
        ExtensionCallStackEntry current;

        public ExtensionCallStack(Object specialVariables, Object block) {
            this.current = new ExtensionCallStackEntry(null, false, specialVariables, block);
        }

        public boolean hasKeptObjects() {
            return this.current.preservedObject != null;
        }

        public boolean hasSingleKeptObject() {
            return this.current.preservedObject != null && this.current.preservedObjects == null;
        }

        public void markOnExitObject(ValueWrapper value) {
            if (this.current.markOnExitObject == null) {
                this.current.markOnExitObject = value;
            } else if (this.current.markOnExitObject != value) {
                this.markOnExitObjectOnList(value);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private void markOnExitObjectOnList(ValueWrapper value) {
            if (this.current.markOnExitObjects == null) {
                this.current.markOnExitObjects = new ArrayList();
                this.current.markOnExitObjects.add(this.current.markOnExitObject);
            }
            this.current.markOnExitObjects.add(value);
        }

        public ArrayList<ValueWrapper> getMarkOnExitObjects() {
            assert (this.current.previous != null);
            assert (this.current.markOnExitObjects != null);
            return this.current.markOnExitObjects;
        }

        public boolean hasMarkObjects() {
            return this.current.markOnExitObject != null;
        }

        public boolean hasSingleMarkObject() {
            return this.current.markOnExitObject != null && this.current.markOnExitObjects == null;
        }

        public ValueWrapper getSingleMarkObject() {
            return this.current.markOnExitObject;
        }

        public void pop() {
            this.current = this.current.previous;
        }

        public void push(boolean keywordsGiven, Object specialVariables, Object block) {
            this.current = new ExtensionCallStackEntry(this.current, keywordsGiven, specialVariables, block);
        }

        public boolean areKeywordsGiven() {
            return this.current.keywordsGiven;
        }

        public Object getSpecialVariables() {
            return this.current.specialVariables;
        }

        public void setSpecialVariables(Object specialVariables) {
            this.current.specialVariables = specialVariables;
        }

        public CapturedException getException() {
            return this.current.capturedException;
        }

        public void setException(CapturedException capturedException) {
            this.current.capturedException = capturedException;
        }

        public Object getBlock() {
            return this.current.block;
        }
    }

    protected static final class ExtensionCallStackEntry {
        private final ExtensionCallStackEntry previous;
        ValueWrapper preservedObject;
        ArrayList<ValueWrapper> preservedObjects;
        private final boolean keywordsGiven;
        private Object specialVariables;
        private final Object block;
        private CapturedException capturedException;
        private ValueWrapper markOnExitObject;
        private ArrayList<ValueWrapper> markOnExitObjects;
        private Object[] marks = null;
        private int marksIndex = 0;

        private ExtensionCallStackEntry(ExtensionCallStackEntry previous, boolean keywordsGiven, Object specialVariables, Object block) {
            this.previous = previous;
            this.keywordsGiven = keywordsGiven;
            this.specialVariables = specialVariables;
            this.block = block;
            this.capturedException = null;
        }
    }

    public static interface MarkerAction {
        public void mark(Object var1);
    }
}

