/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.ArrayList;
import org.truffleruby.cext.ValueWrapper;
import org.truffleruby.core.MarkingService;
import org.truffleruby.core.MarkingServiceNodesFactory;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.dispatch.DispatchNode;

public abstract class MarkingServiceNodes {

    public static abstract class RunMarkOnExitNode
    extends RubyBaseNode {
        public abstract void execute(MarkingService.ExtensionCallStack var1);

        @Specialization(guards={"!stack.hasMarkObjects()"})
        void nothingToMark(MarkingService.ExtensionCallStack stack) {
        }

        @Specialization(guards={"stack.hasSingleMarkObject()"})
        void markSingleObject(MarkingService.ExtensionCallStack stack, @Cached.Shared @Cached DispatchNode callNode) {
            ValueWrapper value = stack.getSingleMarkObject();
            callNode.call((Object)this.getContext().getCoreLibrary().truffleCExtModule, "run_marker", value.getObject());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"stack.hasMarkObjects()", "!stack.hasSingleMarkObject()"})
        void marksToRun(MarkingService.ExtensionCallStack stack, @Cached.Shared @Cached DispatchNode callNode) {
            ArrayList<ValueWrapper> valuesForMarking = stack.getMarkOnExitObjects();
            stack.push(false, nil, nil);
            try {
                for (ValueWrapper value : valuesForMarking) {
                    callNode.call((Object)this.getContext().getCoreLibrary().truffleCExtModule, "run_marker", value.getObject());
                }
            }
            finally {
                stack.pop();
            }
        }

        @NeverDefault
        public static RunMarkOnExitNode create() {
            return MarkingServiceNodesFactory.RunMarkOnExitNodeGen.create();
        }
    }

    public static final class QueueForMarkOnExitNode
    extends RubyBaseNode {
        @NeverDefault
        public static QueueForMarkOnExitNode create() {
            return new QueueForMarkOnExitNode();
        }

        public void execute(ValueWrapper object) {
            this.addToList(this.getLanguage().getCurrentThread().getCurrentFiber().extensionCallStack, object);
        }

        protected void addToList(MarkingService.ExtensionCallStack stack, ValueWrapper object) {
            stack.markOnExitObject(object);
        }
    }

    @GenerateUncached
    public static abstract class KeepAliveNode
    extends RubyBaseNode {
        public abstract void execute(ValueWrapper var1);

        @Specialization(guards={"!stack.hasKeptObjects()"})
        void keepFirstObject(ValueWrapper object, @Bind(value="getStack(object)") MarkingService.ExtensionCallStack stack) {
            stack.current.preservedObject = object;
        }

        @Specialization(guards={"stack.hasSingleKeptObject()"})
        void keepCreatingList(ValueWrapper object, @Bind(value="getStack(object)") MarkingService.ExtensionCallStack stack, @Cached InlinedConditionProfile sameObjectProfile) {
            if (sameObjectProfile.profile((Node)this, object != stack.current.preservedObject)) {
                this.createKeptList(object, stack);
            }
        }

        @Specialization(guards={"stack.hasKeptObjects()", "!stack.hasSingleKeptObject()"})
        @CompilerDirectives.TruffleBoundary
        void keepAddingToList(ValueWrapper object, @Bind(value="getStack(object)") MarkingService.ExtensionCallStack stack) {
            stack.current.preservedObjects.add(object);
        }

        @CompilerDirectives.TruffleBoundary
        private void createKeptList(ValueWrapper object, MarkingService.ExtensionCallStack stack) {
            stack.current.preservedObjects = new ArrayList();
            stack.current.preservedObjects.add(stack.current.preservedObject);
            stack.current.preservedObjects.add(object);
        }

        protected MarkingService.ExtensionCallStack getStack(ValueWrapper object) {
            return this.getLanguage().getCurrentThread().getCurrentFiber().extensionCallStack;
        }
    }
}

