/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.DummyNode;
import org.truffleruby.core.Hashing;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.basicobject.ReferenceEqualNode;
import org.truffleruby.core.cast.NameToJavaStringNode;
import org.truffleruby.core.cast.ToRubyIntegerNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.method.RubyMethod;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.proc.ProcOperations;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.support.RubyIO;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.extra.ffi.Pointer;
import org.truffleruby.interop.TranslateInteropExceptionNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.SafepointAction;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.EmptyArgumentsDescriptor;
import org.truffleruby.language.arguments.KeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.backtrace.Backtrace;
import org.truffleruby.language.control.ExitException;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.control.ThrowException;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.LookupMethodOnSelfNode;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.MetaClassNode;
import org.truffleruby.language.objects.shared.SharedObjects;
import org.truffleruby.language.yield.CallBlockNode;
import org.truffleruby.platform.Signals;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@CoreModule(value="VMPrimitives", isClass=true)
public abstract class VMPrimitiveNodes {

    @Primitive(name="vm_single_context?")
    public static abstract class VMSingleContext
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean singleContext() {
            return this.isSingleContext();
        }
    }

    @Primitive(name="vm_native_argv_length")
    public static abstract class VMNativeArgvLengthNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        long argvLength() {
            long nativeArgvLength = this.getContext().nativeArgvLength;
            if (nativeArgvLength != -1L) {
                return nativeArgvLength;
            }
            int argc = this.getContext().nativeArgc;
            Pointer argv = new Pointer(this.getContext(), this.getContext().nativeArgv, (long)argc * 8L);
            Pointer first = argv.readPointer(this.getContext(), 0L);
            Pointer last = argv.readPointer(this.getContext(), (long)(argc - 1) * 8L);
            long lastByte = last.getAddress() + last.findNullByte(this.getContext(), InteropLibrary.getUncached(), 0L);
            this.getContext().nativeArgvLength = nativeArgvLength = lastByte - first.getAddress();
            return nativeArgvLength;
        }
    }

    @Primitive(name="vm_native_argv")
    public static abstract class VMNativeArgvNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        long argv() {
            return this.getContext().nativeArgv;
        }
    }

    @Primitive(name="arguments_descriptor")
    public static abstract class ArgumentsDescriptorNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyArray argumentsDescriptor(VirtualFrame frame) {
            return this.descriptorToArray(RubyArguments.getDescriptor((Frame)frame));
        }

        @CompilerDirectives.TruffleBoundary
        private RubyArray descriptorToArray(ArgumentsDescriptor descriptor) {
            if (descriptor == EmptyArgumentsDescriptor.INSTANCE) {
                return this.createEmptyArray();
            }
            if (descriptor instanceof KeywordArgumentsDescriptor) {
                KeywordArgumentsDescriptor keywordArgumentsDescriptor = (KeywordArgumentsDescriptor)descriptor;
                Stream<RubySymbol> keywords = Stream.concat(Stream.of("keywords"), Arrays.stream(keywordArgumentsDescriptor.getKeywords())).map(this.getLanguage()::getSymbol);
                return this.createArray(keywords.toArray());
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @Primitive(name="arguments")
    public static abstract class ArgumentsNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyArray arguments(VirtualFrame frame) {
            return this.createArray(RubyArguments.getRawArguments((Frame)frame));
        }
    }

    @Primitive(name="vm_java_version")
    public static abstract class VMJavaVersionNode
    extends PrimitiveArrayArgumentsNode {
        private static final int JAVA_SPECIFICATION_VERSION = VMJavaVersionNode.getJavaSpecificationVersion();

        private static int getJavaSpecificationVersion() {
            String value = System.getProperty("java.specification.version");
            if (value.startsWith("1.")) {
                value = value.substring(2);
            }
            return Integer.parseInt(value);
        }

        @Specialization
        int javaVersion() {
            return JAVA_SPECIFICATION_VERSION;
        }
    }

    @Primitive(name="should_not_reach_here")
    public static abstract class ShouldNotReachHereNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"libString.isRubyString(message)"}, limit="1")
        Object shouldNotReachHere(Object message, @Cached RubyStringLibrary libString) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)RubyGuards.getJavaString(message));
        }
    }

    @Primitive(name="vm_stack_overflow_error_to_init_classes")
    public static abstract class InitStackOverflowClassesEagerlyNode
    extends PrimitiveArrayArgumentsNode {
        private static final String MESSAGE = "initStackOverflowClassesEagerly";

        public static boolean ignore(StackOverflowError e) {
            return e.getMessage() == MESSAGE;
        }

        public static boolean ignore(Object exceptionObject) {
            if (!(exceptionObject instanceof RubyException)) {
                return false;
            }
            RubyException rubyException = (RubyException)exceptionObject;
            Backtrace backtrace = rubyException.backtrace;
            Throwable throwable = backtrace == null ? null : backtrace.getJavaThrowable();
            return throwable instanceof StackOverflowError && InitStackOverflowClassesEagerlyNode.ignore((StackOverflowError)throwable);
        }

        @Specialization
        Object initStackOverflowClassesEagerly() {
            StackOverflowError stackOverflowError = new StackOverflowError(MESSAGE);
            TruffleStackTrace.fillIn((Throwable)stackOverflowError);
            throw stackOverflowError;
        }
    }

    @Primitive(name="vm_hash_end")
    public static abstract class VMHashEndNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        long endHash(long hash) {
            return Hashing.end(hash);
        }
    }

    @Primitive(name="vm_hash_update")
    public static abstract class VMHashUpdateNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        long updateHash(long hash, long value) {
            return Hashing.update(hash, value);
        }

        @Specialization
        long updateHash(long hash, RubyBignum value) {
            return Hashing.update(hash, BigIntegerOps.hashCode(value));
        }

        @Specialization(guards={"!isRubyNumber(value)"})
        Object updateHash(long hash, Object value, @Cached ToRubyIntegerNode toRubyInteger, @Cached InlinedConditionProfile isIntegerProfile, @Cached InlinedConditionProfile isLongProfile, @Cached InlinedConditionProfile isBignumProfile) {
            Object result = toRubyInteger.execute(this, value);
            if (isIntegerProfile.profile((Node)this, result instanceof Integer)) {
                return Hashing.update(hash, ((Integer)result).intValue());
            }
            if (isLongProfile.profile((Node)this, result instanceof Long)) {
                return Hashing.update(hash, (Long)result);
            }
            if (isBignumProfile.profile((Node)this, result instanceof RubyBignum)) {
                return Hashing.update(hash, BigIntegerOps.hashCode((RubyBignum)result));
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @Primitive(name="vm_hash_start")
    public static abstract class VMHashStartNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        long startHash(long salt) {
            return this.getContext().getHashing(this).start(salt);
        }

        @Specialization
        long startHashBigNum(RubyBignum salt) {
            return this.getContext().getHashing(this).start(BigIntegerOps.hashCode(salt));
        }

        @Specialization(guards={"!isRubyNumber(salt)"})
        Object startHashNotNumber(Object salt, @Cached ToRubyIntegerNode toRubyInteger, @Cached InlinedConditionProfile isIntegerProfile, @Cached InlinedConditionProfile isLongProfile, @Cached InlinedConditionProfile isBignumProfile) {
            Object result = toRubyInteger.execute(this, salt);
            if (isIntegerProfile.profile((Node)this, result instanceof Integer)) {
                return this.getContext().getHashing(this).start(((Integer)result).intValue());
            }
            if (isLongProfile.profile((Node)this, result instanceof Long)) {
                return this.getContext().getHashing(this).start((Long)result);
            }
            if (isBignumProfile.profile((Node)this, result instanceof RubyBignum)) {
                return this.getContext().getHashing(this).start(BigIntegerOps.hashCode((RubyBignum)result));
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @Primitive(name="vm_dev_urandom_bytes", lowerFixnum={0})
    public static abstract class VMDevUrandomBytes
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"count >= 0"})
        RubyString readRandomBytes(int count, @Cached TruffleString.FromByteArrayNode fromByteArrayNode) {
            byte[] bytes = this.getContext().getRandomSeedBytes(count);
            return this.createString(fromByteArrayNode, bytes, Encodings.BINARY);
        }

        @Specialization(guards={"count < 0"})
        RubyString negativeCount(int count) {
            throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().argumentError(this.coreStrings().NEGATIVE_STRING_SIZE.createInstance(this.getContext()), (Node)this, null));
        }
    }

    @Primitive(name="vm_set_class")
    public static abstract class VMSetClassNode
    extends PrimitiveArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyIO setClass(RubyIO object, RubyClass newClass) {
            SharedObjects.propagate(this.getLanguage(), object, newClass);
            RubyIO rubyIO = object;
            synchronized (rubyIO) {
                object.setMetaClass(newClass);
            }
            return object;
        }
    }

    @Primitive(name="vm_get_config_section")
    public static abstract class VMGetConfigSectionNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object getSection(Object section, RubyProc block, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached CallBlockNode yieldNode) {
            for (Map.Entry<String, Object> entry : this.getContext().getNativeConfiguration().getSection(RubyGuards.getJavaString(section))) {
                RubyString key = this.createString(fromJavaStringNode, entry.getKey(), Encodings.UTF_8);
                yieldNode.yield(block, new Object[]{key, entry.getValue()});
            }
            return nil;
        }
    }

    @Primitive(name="vm_get_config_item")
    public static abstract class VMGetConfigItemNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object get(Object key) {
            String keyString = RubyGuards.getJavaString(key);
            Object value = this.getContext().getNativeConfiguration().get(keyString);
            if (value == null) {
                return nil;
            }
            return value;
        }
    }

    @Primitive(name="vm_watch_signal", argumentNames={"action"})
    public static abstract class VMWatchSignalNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"libSignalString.isRubyString(signalString)", "libAction.isRubyString(action)"}, limit="1")
        boolean watchSignalString(Object signalString, boolean isRubyDefaultHandler, Object action, @Cached.Shared @Cached RubyStringLibrary libSignalString, @Cached.Exclusive @Cached RubyStringLibrary libAction) {
            String actionString = RubyGuards.getJavaString(action);
            String signalName = RubyGuards.getJavaString(signalString);
            switch (actionString) {
                case "DEFAULT": {
                    return this.restoreDefaultHandler(signalName);
                }
                case "SYSTEM_DEFAULT": {
                    return this.restoreSystemHandler(signalName);
                }
                case "IGNORE": {
                    return this.registerIgnoreHandler(signalName);
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)actionString);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"libSignalString.isRubyString(signalString)"})
        boolean watchSignalProc(Object signalString, boolean isRubyDefaultHandler, RubyProc proc, @Cached.Shared @Cached RubyStringLibrary libSignalString) {
            RubyContext context = this.getContext();
            if (this.getLanguage().getCurrentThread() != context.getThreadManager().getRootThread()) {
                SharedObjects.writeBarrier(this.getLanguage(), proc);
            }
            String signalName = RubyGuards.getJavaString(signalString);
            return this.registerHandler(signalName, signal -> {
                RubyThread rootThread = context.getThreadManager().getRootThread();
                context.getSafepointManager().pauseRubyThreadAndExecute(DummyNode.INSTANCE, VMWatchSignalNode.callProcSafepointAction(proc, signal, rootThread));
            }, isRubyDefaultHandler);
        }

        @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
        private static SafepointAction callProcSafepointAction(final RubyProc proc, final Signal signal, RubyThread rootThread) {
            return new SafepointAction("Handling of signal " + signal, rootThread, true, false){

                @Override
                public void run(RubyThread rubyThread, Node currentNode) {
                    ProcOperations.rootCall(proc, EmptyArgumentsDescriptor.INSTANCE, signal.getNumber());
                }
            };
        }

        @CompilerDirectives.TruffleBoundary
        private boolean restoreDefaultHandler(String signalName) {
            if (this.getContext().getOptions().EMBEDDED) {
                RubyLanguage.LOGGER.warning("restoring default handler for signal " + signalName + " in embedded mode may interfere with other embedded contexts or the host system");
            }
            try {
                return Signals.restoreRubyDefaultHandler(this.getContext(), signalName);
            }
            catch (IllegalArgumentException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentError(e.getMessage(), this));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private boolean restoreSystemHandler(String signalName) {
            if (this.getContext().getOptions().EMBEDDED) {
                RubyLanguage.LOGGER.warning("restoring system handler for signal " + signalName + " in embedded mode may interfere with other embedded contexts or the host system");
            }
            try {
                Signals.restoreSystemHandler(signalName);
            }
            catch (IllegalArgumentException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentError(e.getMessage(), this));
            }
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        private boolean registerIgnoreHandler(String signalName) {
            if (this.getContext().getOptions().EMBEDDED) {
                RubyLanguage.LOGGER.warning("ignoring signal " + signalName + " in embedded mode may interfere with other embedded contexts or the host system");
            }
            try {
                Signals.registerIgnoreHandler(signalName);
            }
            catch (IllegalArgumentException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentError(e.getMessage(), this));
            }
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        private boolean registerHandler(String signalName, SignalHandler newHandler, boolean isRubyDefaultHandler) {
            if (this.getContext().getOptions().EMBEDDED) {
                RubyLanguage.LOGGER.warning("trapping signal " + signalName + " in embedded mode may interfere with other embedded contexts or the host system");
            }
            try {
                Signals.registerHandler(this.getContext(), newHandler, signalName, isRubyDefaultHandler);
            }
            catch (IllegalArgumentException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentError(e.getMessage(), this));
            }
            return true;
        }
    }

    @Primitive(name="vm_throw")
    public static abstract class ThrowNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object doThrow(Object tag, Object value) {
            throw new ThrowException(tag, value);
        }
    }

    @Primitive(name="vm_raise_exception")
    public static abstract class VMRaiseExceptionNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object vmRaiseException(RubyException exception, @Cached InlinedConditionProfile reRaiseProfile) {
            Backtrace backtrace = exception.backtrace;
            RaiseException raiseException = null;
            if (reRaiseProfile.profile((Node)this, backtrace != null && (raiseException = backtrace.getRaiseException()) != null)) {
                assert (raiseException.getException() == exception);
                if (this.getContext().getOptions().BACKTRACE_ON_RAISE) {
                    this.getContext().getDefaultBacktraceFormatter().printRubyExceptionOnEnvStderr("raise: ", raiseException);
                }
                throw raiseException;
            }
            throw new RaiseException(this.getContext(), exception);
        }

        @Specialization(guards={"!isRubyException(exception)"}, limit="getInteropCacheLimit()")
        static Object foreignException(Object exception, @CachedLibrary(value="exception") InteropLibrary interopLibrary, @Cached TranslateInteropExceptionNode translateInteropExceptionNode, @Bind(value="this") Node node) {
            try {
                throw interopLibrary.throwException(exception);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropExceptionNode.execute(node, (InteropException)e);
            }
        }

        public static RaiseException reRaiseException(RubyContext context, RubyException exception) {
            Backtrace backtrace = exception.backtrace;
            if (backtrace != null && backtrace.getRaiseException() != null) {
                throw backtrace.getRaiseException();
            }
            throw new RaiseException(context, exception);
        }
    }

    @Primitive(name="vm_method_lookup")
    public static abstract class VMMethodLookupNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object vmMethodLookup(VirtualFrame frame, Object receiver, Object name, @Cached NameToJavaStringNode nameToJavaStringNode, @Cached LookupMethodOnSelfNode lookupMethodNode) {
            String normalizedName = nameToJavaStringNode.execute(this, name);
            InternalMethod method = lookupMethodNode.lookupIgnoringVisibility((Frame)frame, receiver, normalizedName);
            if (method == null) {
                return nil;
            }
            RubyMethod instance = new RubyMethod(this.coreLibrary().methodClass, this.getLanguage().methodShape, receiver, method);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }

    @Primitive(name="vm_builtin_method?")
    public static abstract class IsBuiltinMethodNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean isBuiltinMethod(VirtualFrame frame, Object receiver, RubySymbol name, @Cached LookupMethodOnSelfNode lookupMethodNode) {
            InternalMethod method = lookupMethodNode.lookupIgnoringVisibility((Frame)frame, receiver, name.getString());
            if (method == null) {
                return false;
            }
            return method.isBuiltIn();
        }
    }

    @Primitive(name="vm_method_is_basic")
    public static abstract class VMMethodIsBasicNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean vmMethodIsBasic(RubyMethod method) {
            return method.method.isBuiltIn();
        }
    }

    @Primitive(name="vm_extended_modules")
    public static abstract class VMExtendedModulesNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object vmExtendedModules(Object object, RubyProc block, @Cached MetaClassNode metaClassNode, @Cached CallBlockNode yieldNode, @Cached InlinedConditionProfile isSingletonProfile) {
            RubyClass metaClass = metaClassNode.execute(this, object);
            if (isSingletonProfile.profile((Node)this, metaClass.isSingleton)) {
                for (RubyModule included : metaClass.fields.prependedAndIncludedModules()) {
                    yieldNode.yield(block, included);
                }
            }
            return nil;
        }
    }

    @Primitive(name="vm_exit", lowerFixnum={0})
    public static abstract class VMExitNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object vmExit(int status) {
            throw new ExitException(status, (Node)this);
        }
    }

    @Primitive(name="vm_catch")
    public static abstract class CatchNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object doCatch(Object tag, RubyProc block, @Cached InlinedBranchProfile catchProfile, @Cached InlinedConditionProfile matchProfile, @Cached ReferenceEqualNode referenceEqualNode, @Cached CallBlockNode yieldNode) {
            try {
                return yieldNode.yield(block, tag);
            }
            catch (ThrowException e) {
                catchProfile.enter((Node)this);
                if (matchProfile.profile((Node)this, referenceEqualNode.execute(this, e.getTag(), tag))) {
                    return e.getValue();
                }
                throw e;
            }
        }
    }
}

