/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.CountingConditionProfile;
import org.truffleruby.core.array.ArrayAppendOneNodeGen;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

@NodeChildren(value={@NodeChild(value="arrayNode", type=RubyNode.class), @NodeChild(value="valueNode", type=RubyNode.class)})
@ImportStatic(value={ArrayGuards.class})
@ReportPolymorphism
public abstract class ArrayAppendOneNode
extends RubyContextSourceNode {
    @NeverDefault
    public static ArrayAppendOneNode create() {
        return ArrayAppendOneNodeGen.create(null, null);
    }

    public abstract RubyArray executeAppendOne(RubyArray var1, Object var2);

    public abstract RubyNode getArrayNode();

    public abstract RubyNode getValueNode();

    @Specialization(guards={"stores.acceptsValue(store, value)"}, limit="storageStrategyLimit()")
    RubyArray appendOneSameType(RubyArray array, Object value, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached CountingConditionProfile extendProfile) {
        int oldSize = array.size;
        int newSize = oldSize + 1;
        int length = stores.capacity(store);
        if (extendProfile.profile(newSize > length)) {
            int capacity = ArrayUtils.capacityForOneMore(this.getLanguage(), length);
            Object newStore = stores.expand(store, capacity);
            stores.write(newStore, oldSize, value);
            ArrayHelpers.setStoreAndSize(array, newStore, newSize);
        } else {
            stores.write(store, oldSize, value);
            ArrayHelpers.setSize(array, newSize);
        }
        return array;
    }

    @Specialization(guards={"!currentStores.acceptsValue(array.getStore(), value)"}, limit="storageStrategyLimit()")
    RubyArray appendOneGeneralizeNonMutable(RubyArray array, Object value, @Bind(value="array.getStore()") Object currentStore, @CachedLibrary(value="currentStore") ArrayStoreLibrary currentStores, @CachedLibrary(limit="storageStrategyLimit()") ArrayStoreLibrary newStores) {
        int oldSize = array.size;
        int newSize = oldSize + 1;
        int oldCapacity = currentStores.capacity(currentStore);
        int newCapacity = newSize > oldCapacity ? ArrayUtils.capacityForOneMore(this.getLanguage(), oldCapacity) : oldCapacity;
        Object newStore = currentStores.allocateForNewValue(currentStore, value, newCapacity);
        currentStores.copyContents(currentStore, 0, newStore, 0, oldSize);
        newStores.write(newStore, oldSize, value);
        ArrayHelpers.setStoreAndSize(array, newStore, newSize);
        return array;
    }

    @Override
    public RubyNode cloneUninitialized() {
        ArrayAppendOneNode copy = ArrayAppendOneNodeGen.create(this.getArrayNode().cloneUninitialized(), this.getValueNode().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

