/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.core.array.ArrayBuilderNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

public final class ArrayConcatNode
extends RubyContextSourceNode {
    @Node.Children
    private final RubyNode[] children;
    @Node.Child
    private ArrayBuilderNode arrayBuilderNode;
    private final ConditionProfile isArrayProfile = ConditionProfile.create();

    public ArrayConcatNode(RubyNode[] children) {
        assert (children.length > 1);
        this.children = children;
    }

    @Override
    @ExplodeLoop
    public RubyArray execute(VirtualFrame frame) {
        if (this.arrayBuilderNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.arrayBuilderNode = (ArrayBuilderNode)this.insert(ArrayBuilderNode.create());
        }
        int totalLength = 0;
        Object[] values = new Object[this.children.length];
        for (int n = 0; n < this.children.length; ++n) {
            values[n] = this.children[n].execute(frame);
            Object value = values[n];
            if (this.isArrayProfile.profile(value instanceof RubyArray)) {
                totalLength += ((RubyArray)value).size;
                continue;
            }
            ++totalLength;
        }
        ArrayBuilderNode.BuilderState state = this.arrayBuilderNode.start(totalLength);
        int index = 0;
        for (int n = 0; n < this.children.length; ++n) {
            Object value = values[n];
            if (this.isArrayProfile.profile(value instanceof RubyArray)) {
                RubyArray childArray = (RubyArray)value;
                this.arrayBuilderNode.appendArray(state, index, childArray);
                index += childArray.size;
                continue;
            }
            this.arrayBuilderNode.appendValue(state, index, value);
            ++index;
        }
        return this.createArray(this.arrayBuilderNode.finish(state, index), index);
    }

    @Override
    @ExplodeLoop
    public void doExecuteVoid(VirtualFrame frame) {
        for (int n = 0; n < this.children.length; ++n) {
            this.children[n].doExecuteVoid(frame);
        }
    }

    @Override
    public RubyNode cloneUninitialized() {
        ArrayConcatNode copy = new ArrayConcatNode(ArrayConcatNode.cloneUninitialized(this.children));
        return copy.copyFlags(this);
    }
}

