/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import org.truffleruby.core.array.ArrayAppendOneNode;
import org.truffleruby.core.array.ArrayEnsureCapacityNode;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.language.RubyBaseNode;

@ImportStatic(value={ArrayGuards.class})
@ReportPolymorphism
public abstract class ArrayWriteNormalizedNode
extends RubyBaseNode {
    public abstract Object executeWrite(RubyArray var1, int var2, Object var3);

    @Specialization(guards={"isInBounds(array, index)", "stores.acceptsValue(store, value)"}, limit="storageStrategyLimit()")
    Object writeWithin(RubyArray array, int index, Object value, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
        stores.write(store, index, value);
        return value;
    }

    @Specialization(guards={"isInBounds(array, index)", "!stores.acceptsValue(store, value)"}, limit="storageStrategyLimit()")
    Object writeWithinGeneralizeNonMutable(RubyArray array, int index, Object value, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @CachedLibrary(limit="1") @Cached.Exclusive ArrayStoreLibrary newStores) {
        int size = array.size;
        Object newStore = stores.allocateForNewValue(store, value, size);
        stores.copyContents(store, 0, newStore, 0, size);
        newStores.write(newStore, index, value);
        array.setStore(newStore);
        return value;
    }

    @Specialization(guards={"isExtendingByOne(array, index)"})
    Object writeExtendByOne(RubyArray array, int index, Object value, @Cached ArrayAppendOneNode appendNode) {
        appendNode.executeAppendOne(array, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(guards={"!isInBounds(array, index)", "!isExtendingByOne(array, index)", "stores.isPrimitive(store)"}, limit="storageStrategyLimit()")
    Object writeBeyondPrimitive(RubyArray array, int index, Object value, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @CachedLibrary(limit="1") @Cached.Exclusive ArrayStoreLibrary newStores, @Cached @Cached.Exclusive LoopConditionProfile loopProfile) {
        int newSize = index + 1;
        Object objectStore = stores.allocateForNewValue(store, nil, newSize);
        int oldSize = array.size;
        stores.copyContents(store, 0, objectStore, 0, oldSize);
        int n = oldSize;
        try {
            while (loopProfile.inject(n < index)) {
                newStores.write(objectStore, n, nil);
                TruffleSafepoint.poll((Node)this);
                ++n;
            }
        }
        finally {
            this.profileAndReportLoopCount(loopProfile, n - oldSize);
        }
        newStores.write(objectStore, index, value);
        ArrayHelpers.setStoreAndSize(array, objectStore, newSize);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(guards={"!isInBounds(array, index)", "!isExtendingByOne(array, index)", "!stores.isPrimitive(store)"}, limit="storageStrategyLimit()")
    Object writeBeyondObject(RubyArray array, int index, Object value, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @CachedLibrary(limit="1") @Cached.Exclusive ArrayStoreLibrary newStores, @Cached ArrayEnsureCapacityNode ensureCapacityNode, @Cached @Cached.Exclusive LoopConditionProfile loopProfile) {
        Object newStore = ensureCapacityNode.executeEnsureCapacity(array, index + 1);
        int n = array.size;
        try {
            while (loopProfile.inject(n < index)) {
                newStores.write(newStore, n, nil);
                TruffleSafepoint.poll((Node)this);
                ++n;
            }
        }
        finally {
            this.profileAndReportLoopCount(loopProfile, n - array.size);
        }
        newStores.write(newStore, index, value);
        ArrayHelpers.setSize(array, index + 1);
        return value;
    }

    protected static boolean isInBounds(RubyArray array, int index) {
        return index >= 0 && index < array.size;
    }

    protected static boolean isExtendingByOne(RubyArray array, int index) {
        return index == array.size;
    }
}

