/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayIndexNodes;
import org.truffleruby.core.array.ArraySliceNode;
import org.truffleruby.core.array.ArraySliceNodeGen;
import org.truffleruby.core.array.AssignableNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.SplatCastNode;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

public final class MultipleAssignmentNode
extends RubyContextSourceNode
implements AssignableNode {
    @Node.Child
    RubyNode rhsNode;
    @Node.Child
    SplatCastNode splatCastNode;
    @Node.Children
    final AssignableNode[] preNodes;
    @Node.Child
    AssignableNode restNode;
    @Node.Children
    final AssignableNode[] postNodes;
    @Node.Child
    ArrayIndexNodes.ReadNormalizedNode arrayReadNormalizedNode;
    @Node.Child
    ArraySliceNode arraySliceNode;
    private final ConditionProfile enoughElementsForAllPost;

    public MultipleAssignmentNode(AssignableNode[] preNodes, AssignableNode restNode, AssignableNode[] postNodes, SplatCastNode splatCastNode, RubyNode rhsNode) {
        this.preNodes = preNodes;
        this.restNode = restNode;
        this.postNodes = postNodes;
        this.splatCastNode = splatCastNode;
        this.rhsNode = rhsNode;
        this.enoughElementsForAllPost = postNodes.length == 0 ? null : ConditionProfile.create();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object rhs = this.rhsNode.execute(frame);
        this.assign(frame, rhs);
        return rhs;
    }

    @Override
    @ExplodeLoop
    public void assign(VirtualFrame frame, Object rhs) {
        RubyArray array = (RubyArray)this.splatCastNode.execute(rhs);
        for (int i = 0; i < this.preNodes.length; ++i) {
            this.preNodes[i].assign(frame, this.read(array, i));
        }
        if (this.restNode != null) {
            this.restNode.assign(frame, this.readSlice(array));
        }
        if (this.postNodes.length > 0) {
            int size = array.size;
            for (int i = 0; i < this.postNodes.length; ++i) {
                int index = this.enoughElementsForAllPost.profile(size >= this.preNodes.length + this.postNodes.length) ? size - this.postNodes.length + i : this.preNodes.length + i;
                this.postNodes[i].assign(frame, this.read(array, index));
            }
        }
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        return FrozenStrings.ASSIGNMENT;
    }

    private Object read(RubyArray array, int i) {
        if (this.arrayReadNormalizedNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.arrayReadNormalizedNode = (ArrayIndexNodes.ReadNormalizedNode)this.insert(ArrayIndexNodes.ReadNormalizedNode.create());
        }
        return this.arrayReadNormalizedNode.executeRead(array, i);
    }

    private Object readSlice(RubyArray array) {
        if (this.arraySliceNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.arraySliceNode = (ArraySliceNode)this.insert(ArraySliceNodeGen.create(this.preNodes.length, -this.postNodes.length, null));
        }
        return this.arraySliceNode.execute(array);
    }

    @Override
    public AssignableNode toAssignableNode() {
        this.rhsNode = null;
        return this;
    }

    @Override
    public AssignableNode cloneUninitializedAssignable() {
        return (AssignableNode)((Object)this.cloneUninitialized());
    }

    @Override
    public RubyNode cloneUninitialized() {
        MultipleAssignmentNode copy = new MultipleAssignmentNode(this.cloneUninitializedAssignable(this.preNodes), this.cloneUninitializedAssignable(this.restNode), this.cloneUninitializedAssignable(this.postNodes), (SplatCastNode)this.splatCastNode.cloneUninitialized(), RubyNode.cloneUninitialized(this.rhsNode));
        return copy.copyFlags(this);
    }

    protected AssignableNode[] cloneUninitializedAssignable(AssignableNode[] nodes) {
        AssignableNode[] copies = new AssignableNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            copies[i] = nodes[i].cloneUninitializedAssignable();
        }
        return copies;
    }

    protected AssignableNode cloneUninitializedAssignable(AssignableNode node) {
        return node == null ? null : node.cloneUninitializedAssignable();
    }
}

