/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array.library;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import java.util.Set;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.array.library.NativeArrayStorage;
import org.truffleruby.core.array.library.SharedArrayStorage;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.ObjectGraphNode;

@ExportLibrary(value=ArrayStoreLibrary.class)
@GenerateUncached
@ImportStatic(value={ArrayGuards.class})
public final class DelegatedArrayStorage
implements ObjectGraphNode {
    public final Object storage;
    public final int offset;
    public final int length;

    public DelegatedArrayStorage(Object storage, int offset, int length) {
        assert (offset >= 0);
        assert (length >= 0);
        assert (!(storage instanceof DelegatedArrayStorage));
        assert (!(storage instanceof NativeArrayStorage));
        assert (!(storage instanceof SharedArrayStorage));
        this.storage = storage;
        this.offset = offset;
        this.length = length;
    }

    @ExportMessage
    protected Object read(int index, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.read(this.storage, index + this.offset);
    }

    @ExportMessage
    protected boolean isPrimitive(@CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.isPrimitive(this.storage);
    }

    @ExportMessage
    public Object backingStore(@CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.backingStore(this.storage);
    }

    @ExportMessage
    protected Object makeShared(int size, @CachedLibrary(value="this") ArrayStoreLibrary library) {
        library.shareElements(this, 0, size);
        return new SharedArrayStorage(this);
    }

    @ExportMessage
    protected void shareElements(int start, int end, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        stores.shareElements(this.storage, this.offset + start, this.offset + end);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    protected String toString(@CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return String.format("Delegate of (%s)", stores.toString(this.storage));
    }

    @ExportMessage
    protected int capacity() {
        return this.length;
    }

    @ExportMessage
    protected Object expand(int capacity) {
        return new DelegatedArrayStorage(this.storage, this.offset, capacity);
    }

    @ExportMessage
    protected Object extractRange(int start, int end) {
        return new DelegatedArrayStorage(this.storage, this.offset + start, end - start);
    }

    @ExportMessage
    protected Object[] boxedCopyOfRange(int start, int length, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.boxedCopyOfRange(this.storage, this.offset + start, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage(limit="storageStrategyLimit()")
    protected void copyContents(int srcStart, Object destStore, int destStart, int length, @CachedLibrary(value="this") ArrayStoreLibrary node, @Cached LoopConditionProfile loopProfile, @CachedLibrary(value="this.storage") ArrayStoreLibrary srcStores, @CachedLibrary(value="destStore") ArrayStoreLibrary destStores) {
        int i = 0;
        try {
            while (loopProfile.inject(i < length)) {
                destStores.write(destStore, i + destStart, srcStores.read(this.storage, srcStart + this.offset + i));
                TruffleSafepoint.poll((Node)destStores);
                ++i;
            }
        }
        finally {
            RubyBaseNode.profileAndReportLoopCount(node.getNode(), loopProfile, i);
        }
    }

    @ExportMessage
    protected void clear(int start, int length) {
    }

    @ExportMessage
    protected Object toJavaArrayCopy(int length, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        Object newStore = stores.unsharedAllocator(this.storage).allocate(length);
        stores.copyContents(this.storage, this.offset, newStore, 0, length);
        return newStore;
    }

    @ExportMessage
    protected void sort(int size) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnsupportedOperationException();
    }

    @ExportMessage
    protected Iterable<Object> getIterable(int from, int length, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.getIterable(this.storage, from + this.offset, length);
    }

    @ExportMessage
    protected ArrayStoreLibrary.ArrayAllocator generalizeForValue(Object newValue, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.generalizeForValue(this.storage, newValue);
    }

    @ExportMessage
    protected ArrayStoreLibrary.ArrayAllocator generalizeForStore(Object newStore, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.generalizeForStore(this.storage, newStore);
    }

    @ExportMessage
    public ArrayStoreLibrary.ArrayAllocator generalizeForSharing(@CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.generalizeForSharing(this.storage);
    }

    @ExportMessage
    protected Object allocateForNewValue(Object newValue, int length, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.allocateForNewValue(this.storage, newValue, length);
    }

    @ExportMessage
    protected Object allocateForNewStore(Object newStore, int length, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.allocateForNewStore(this.storage, newStore, length);
    }

    @ExportMessage
    protected boolean isDefaultValue(Object value, @CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.isDefaultValue(this.storage, value);
    }

    @ExportMessage
    protected ArrayStoreLibrary.ArrayAllocator allocator(@CachedLibrary(value="this.storage") ArrayStoreLibrary stores) {
        return stores.unsharedAllocator(this.storage);
    }

    public boolean hasObjectArrayStorage() {
        return this.storage.getClass() == Object[].class;
    }

    @Override
    public void getAdjacentObjects(Set<Object> reachable) {
        if (this.hasObjectArrayStorage()) {
            Object[] objectArray = (Object[])this.storage;
            for (int i = this.offset; i < this.offset + this.length; ++i) {
                Object value = objectArray[i];
                if (!ObjectGraph.isRubyObject(value)) continue;
                reachable.add(value);
            }
        }
    }
}

