/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array.library;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.truffleruby.RubyContext;
import org.truffleruby.cext.UnwrapNode;
import org.truffleruby.cext.ValueWrapper;
import org.truffleruby.cext.WrapNode;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.array.library.ObjectArrayStore;
import org.truffleruby.core.array.library.SharedArrayStorage;
import org.truffleruby.extra.ffi.Pointer;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.ObjectGraphNode;
import org.truffleruby.language.objects.shared.WriteBarrierNode;

@ExportLibrary(value=ArrayStoreLibrary.class)
@GenerateUncached
@ImportStatic(value={ArrayGuards.class})
public final class NativeArrayStorage
implements ObjectGraphNode {
    private final Pointer pointer;
    private final Object[] markedObjects;
    public final int length;

    public NativeArrayStorage(Pointer pointer, int length) {
        this(pointer, length, new Object[length]);
    }

    private NativeArrayStorage(Pointer pointer, int length, Object[] markedObjects) {
        this.pointer = pointer;
        this.length = length;
        this.markedObjects = markedObjects;
    }

    @ExportMessage
    protected boolean acceptsValue(Object value) {
        return true;
    }

    @ExportMessage
    protected boolean acceptsAllValues(Object otherStore) {
        return true;
    }

    @ExportMessage
    protected boolean isMutable() {
        return true;
    }

    @ExportMessage
    protected boolean isNative() {
        return true;
    }

    @ExportMessage
    static String toString(NativeArrayStorage storage) {
        return "NativeArrayStorage";
    }

    @ExportMessage
    protected Object read(int index, @Cached.Shared @Cached UnwrapNode unwrapNode, @Bind(value="$node") Node node) {
        return unwrapNode.execute(node, this.readElement(index));
    }

    @ExportMessage
    protected void write(int index, Object value, @CachedLibrary(limit="1") InteropLibrary wrappers, @Cached WrapNode wrapNode, @Cached InlinedConditionProfile isPointerProfile, @Bind(value="$node") Node node) {
        long address;
        ValueWrapper wrapper = wrapNode.execute(value);
        if (!isPointerProfile.profile(node, wrappers.isPointer((Object)wrapper))) {
            wrappers.toNative((Object)wrapper);
        }
        try {
            assert (wrappers.isPointer((Object)wrapper));
            address = wrappers.asPointer((Object)wrapper);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnsupportedOperationException();
        }
        this.writeElement(index, address);
    }

    @ExportMessage
    protected int capacity() {
        return this.length;
    }

    @ExportMessage
    protected NativeArrayStorage expand(int newCapacity, @CachedLibrary(value="this") ArrayStoreLibrary node) {
        int capacity = this.length;
        Pointer newPointer = Pointer.malloc(RubyContext.get((Node)node), capacity);
        newPointer.writeBytes(0L, this.pointer, 0, capacity);
        newPointer.writeBytes(capacity, newCapacity - capacity, (byte)0);
        Object[] newMarkedObjects = ArrayUtils.grow(this.markedObjects, newCapacity);
        return new NativeArrayStorage(newPointer, newCapacity, newMarkedObjects);
    }

    @ExportMessage
    protected Object[] boxedCopyOfRange(int start, int length, @Cached.Shared @Cached UnwrapNode unwrapNode, @Bind(value="$node") Node node) {
        Object[] newStore = new Object[length];
        for (int i = 0; i < length; ++i) {
            newStore[i] = unwrapNode.execute(node, this.readElement(start + i));
        }
        return newStore;
    }

    @ExportMessage
    static Object makeShared(NativeArrayStorage store, int size, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
        stores.shareElements(store, 0, size);
        return new SharedArrayStorage(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage(limit="storageStrategyLimit()")
    protected void copyContents(int srcStart, Object destStore, int destStart, int length, @CachedLibrary(value="this") ArrayStoreLibrary srcStores, @Cached @Cached.Exclusive LoopConditionProfile loopProfile, @CachedLibrary(value="destStore") ArrayStoreLibrary destStores) {
        int i = 0;
        try {
            while (loopProfile.inject(i < length)) {
                destStores.write(destStore, destStart + i, srcStores.read(this, srcStart + i));
                TruffleSafepoint.poll((Node)destStores);
                ++i;
            }
        }
        finally {
            RubyBaseNode.profileAndReportLoopCount(srcStores.getNode(), loopProfile, i);
        }
    }

    @ExportMessage
    protected void clear(int start, int length) {
        this.pointer.writeBytes((long)start * 8L, (long)length * 8L, (byte)0);
    }

    @ExportMessage
    static void fill(NativeArrayStorage store, int start, int length, Object value, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
        for (int i = start; i < length; ++i) {
            stores.write(store, i, value);
        }
    }

    @ExportMessage
    protected Object[] toJavaArrayCopy(int size, @Cached.Shared @Cached UnwrapNode unwrapNode, @Bind(value="$node") Node node) {
        Object[] newStore = new Object[size];
        assert (size >= this.length);
        for (int i = 0; i < this.length; ++i) {
            newStore[i] = unwrapNode.execute(node, this.readElement(i));
        }
        return newStore;
    }

    @ExportMessage
    static Iterable<Object> getIterable(final NativeArrayStorage store, final int from, final int length, final @CachedLibrary(value="store") ArrayStoreLibrary stores) {
        return () -> new Iterator<Object>(){
            private int n;
            {
                this.n = from;
            }

            @Override
            public boolean hasNext() {
                return this.n < from + length;
            }

            @Override
            public Object next() throws NoSuchElementException {
                if (this.n >= from + length) {
                    throw new NoSuchElementException();
                }
                Object object = stores.read(store, this.n);
                ++this.n;
                return object;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    @ExportMessage
    protected boolean isDefaultValue(Object value) {
        return false;
    }

    @ExportMessage
    protected ArrayStoreLibrary.ArrayAllocator allocator() {
        return ObjectArrayStore.OBJECT_ARRAY_ALLOCATOR;
    }

    @ExportMessage
    protected ArrayStoreLibrary.ArrayAllocator generalizeForValue(Object newValue) {
        return ObjectArrayStore.OBJECT_ARRAY_ALLOCATOR;
    }

    @ExportMessage
    protected ArrayStoreLibrary.ArrayAllocator generalizeForStore(Object newStore) {
        return ObjectArrayStore.OBJECT_ARRAY_ALLOCATOR;
    }

    @ExportMessage
    public ArrayStoreLibrary.ArrayAllocator generalizeForSharing() {
        return SharedArrayStorage.SHARED_OBJECT_ARRAY_ALLOCATOR;
    }

    @ExportMessage
    protected Object allocateForNewValue(Object newValue, int length) {
        return ObjectArrayStore.OBJECT_ARRAY_ALLOCATOR.allocate(length);
    }

    @ExportMessage
    protected Object allocateForNewStore(Object newValue, int length) {
        return ObjectArrayStore.OBJECT_ARRAY_ALLOCATOR.allocate(length);
    }

    public long readElement(int index) {
        return this.pointer.readLong((long)index * 8L);
    }

    public void writeElement(int index, long value) {
        this.pointer.writeLong((long)index * 8L, value);
    }

    public long getAddress() {
        return this.pointer.getAddress();
    }

    @Override
    public void getAdjacentObjects(Set<Object> reachable) {
        for (int i = 0; i < this.length; ++i) {
            Object value = UnwrapNode.UnwrapNativeNode.executeUncached(this.readElement(i));
            if (!ObjectGraph.isRubyObject(value)) continue;
            reachable.add(value);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void preserveMembers() {
        for (int i = 0; i < this.length; ++i) {
            Object value;
            this.markedObjects[i] = value = UnwrapNode.UnwrapNativeNode.executeUncached(this.readElement(i));
        }
    }

    @ExportMessage
    static final class ShareElements {
        ShareElements() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static void shareElements(NativeArrayStorage store, int start, int end, @CachedLibrary(value="store") ArrayStoreLibrary arrayStoreLibrary, @Cached @Cached.Exclusive LoopConditionProfile loopProfile, @Cached WriteBarrierNode writeBarrierNode, @Bind(value="$node") Node node) {
            int i = start;
            try {
                while (loopProfile.inject(i < end)) {
                    writeBarrierNode.execute(node, arrayStoreLibrary.read(store, i));
                    ++i;
                }
            }
            finally {
                RubyBaseNode.profileAndReportLoopCount((Node)arrayStoreLibrary, loopProfile, i);
            }
        }
    }
}

