/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.utils.Utils;

@GenerateUncached
public abstract class ToIntNode
extends RubyBaseNode {
    public abstract int execute(Object var1);

    @Specialization
    int coerceInt(int value) {
        return value;
    }

    @Specialization(guards={"fitsInInteger(value)"})
    int coerceFittingLong(long value) {
        return (int)value;
    }

    @Specialization(guards={"!fitsInInteger(value)"})
    int coerceTooBigLong(long value) {
        throw new RaiseException(this.getContext(), this.coreExceptions().rangeError("long too big to convert into `int'", this));
    }

    @Specialization
    int coerceRubyBignum(RubyBignum value) {
        throw new RaiseException(this.getContext(), this.coreExceptions().rangeError("bignum too big to convert into `long'", this));
    }

    @Specialization
    int coerceDouble(double value, @Cached InlinedBranchProfile errorProfile) {
        if (CoreLibrary.fitsIntoInteger((long)value)) {
            return (int)value;
        }
        errorProfile.enter((Node)this);
        throw new RaiseException(this.getContext(), this.coreExceptions().rangeError(Utils.concat("float ", value, " out of range of integer"), this));
    }

    @Specialization
    int coerceNil(Nil value) {
        throw new RaiseException(this.getContext(), this.coreExceptions().typeError("no implicit conversion from nil to integer", this));
    }

    @Fallback
    int coerceObject(Object object, @Cached DispatchNode toIntNode, @Cached ToIntNode fitNode) {
        Object coerced = toIntNode.call((Object)this.coreLibrary().truffleTypeModule, "rb_to_int_fallback", object);
        return fitNode.execute(coerced);
    }
}

