/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.ISO8859_1Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jcodings.specific.UTF32BEEncoding;
import org.jcodings.specific.UTF32LEEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.FrozenStringLiterals;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.core.string.TStringConstants;

public final class Encodings {
    public static final int INITIAL_NUMBER_OF_ENCODINGS = EncodingDB.getEncodings().size();
    public static final RubyEncoding US_ASCII = Encodings.initializeUsAscii();
    private static final RubyEncoding[] BUILT_IN_ENCODINGS = Encodings.initializeRubyEncodings();
    public static final RubyEncoding BINARY = BUILT_IN_ENCODINGS[ASCIIEncoding.INSTANCE.getIndex()];
    public static final RubyEncoding UTF_8 = BUILT_IN_ENCODINGS[UTF8Encoding.INSTANCE.getIndex()];
    public static final RubyEncoding UTF16LE = BUILT_IN_ENCODINGS[UTF16LEEncoding.INSTANCE.getIndex()];
    public static final RubyEncoding UTF16BE = BUILT_IN_ENCODINGS[UTF16BEEncoding.INSTANCE.getIndex()];
    public static final RubyEncoding UTF32LE = BUILT_IN_ENCODINGS[UTF32LEEncoding.INSTANCE.getIndex()];
    public static final RubyEncoding UTF32BE = BUILT_IN_ENCODINGS[UTF32BEEncoding.INSTANCE.getIndex()];
    public static final RubyEncoding ISO_8859_1 = BUILT_IN_ENCODINGS[ISO8859_1Encoding.INSTANCE.getIndex()];
    public static final RubyEncoding UTF16_DUMMY = BUILT_IN_ENCODINGS[((EncodingDB.Entry)EncodingDB.getEncodings().get(StringOperations.encodeAsciiBytes("UTF-16"))).getEncoding().getIndex()];
    public static final RubyEncoding UTF32_DUMMY = BUILT_IN_ENCODINGS[((EncodingDB.Entry)EncodingDB.getEncodings().get(StringOperations.encodeAsciiBytes("UTF-32"))).getEncoding().getIndex()];
    static final Encoding DUMMY_ENCODING_BASE = Encodings.createDummyEncoding();

    private static RubyEncoding initializeUsAscii() {
        USASCIIEncoding encoding = USASCIIEncoding.INSTANCE;
        return new RubyEncoding(encoding.getIndex());
    }

    private static RubyEncoding[] initializeRubyEncodings() {
        RubyEncoding[] encodings = new RubyEncoding[INITIAL_NUMBER_OF_ENCODINGS];
        for (EncodingDB.Entry entry : EncodingDB.getEncodings()) {
            RubyEncoding rubyEncoding;
            Encoding encoding = entry.getEncoding();
            if (encoding == USASCIIEncoding.INSTANCE) {
                rubyEncoding = US_ASCII;
            } else {
                TruffleString tstring = TStringConstants.TSTRING_CONSTANTS.get(encoding.toString());
                if (tstring == null) {
                    throw CompilerDirectives.shouldNotReachHere((String)("no TStringConstants for " + encoding));
                }
                ImmutableRubyString name = FrozenStringLiterals.createStringAndCacheLater(tstring, US_ASCII);
                rubyEncoding = new RubyEncoding(encoding, name, encoding.getIndex());
            }
            encodings[encoding.getIndex()] = rubyEncoding;
        }
        return encodings;
    }

    private static Encoding createDummyEncoding() {
        EncodingDB.Entry entry = EncodingDB.dummy((byte[])StringOperations.encodeAsciiBytes("TRUFFLERUBY_DUMMY_ENCODING"));
        return entry.getEncoding();
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyEncoding newRubyEncoding(RubyLanguage language, Encoding encoding, int index, byte[] name) {
        TruffleString tstring = TStringUtils.fromByteArray(name, US_ASCII);
        ImmutableRubyString string = language.getFrozenStringLiteral(tstring, US_ASCII);
        return new RubyEncoding(encoding, string, index);
    }

    public static RubyEncoding getBuiltInEncoding(Encoding jcoding) {
        RubyEncoding rubyEncoding = BUILT_IN_ENCODINGS[jcoding.getIndex()];
        assert (rubyEncoding.jcoding == jcoding);
        return rubyEncoding;
    }
}

