/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.exception;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.exception.RubySystemCallError;
import org.truffleruby.core.kernel.KernelNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.ModuleFields;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.thread.ThreadNodes;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyConstant;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.backtrace.Backtrace;
import org.truffleruby.language.control.KillException;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;

public abstract class ExceptionOperations {
    public static Object getExceptionObject(AbstractTruffleException exception) {
        assert (!(exception instanceof KillException)) : "KillException should not be used as an exception object: " + exception;
        if (exception instanceof RaiseException) {
            return ((RaiseException)exception).getException();
        }
        return exception;
    }

    public static Object getExceptionObject(Node node, AbstractTruffleException exception, InlinedConditionProfile raiseExceptionProfile) {
        assert (!(exception instanceof KillException)) : "KillException should not be used as an exception object: " + exception;
        if (raiseExceptionProfile.profile(node, exception instanceof RaiseException)) {
            return ((RaiseException)exception).getException();
        }
        return exception;
    }

    @CompilerDirectives.TruffleBoundary
    public static String getMessage(Throwable throwable) {
        return throwable.getMessage();
    }

    @CompilerDirectives.TruffleBoundary
    public static String messageFieldToString(RubyException exception) {
        Object message = exception.message;
        RubyStringLibrary strings = RubyStringLibrary.getUncached();
        if (message == null || message == Nil.INSTANCE) {
            ModuleFields exceptionClass = exception.getLogicalClass().fields;
            return exceptionClass.getName();
        }
        if (strings.isRubyString(message)) {
            return RubyGuards.getJavaString(message);
        }
        return message.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static String messageToString(RubyException exception) {
        Object messageObject = null;
        try {
            messageObject = DispatchNode.getUncached().call(exception, "message");
        }
        catch (RaiseException raiseException) {
            // empty catch block
        }
        if (messageObject != null && RubyStringLibrary.getUncached().isRubyString(messageObject)) {
            return RubyGuards.getJavaString(messageObject);
        }
        return ExceptionOperations.messageFieldToString(exception);
    }

    public static RubyException createRubyException(RubyContext context, RubyClass rubyClass, Object message, Node node, Throwable javaException) {
        Backtrace backtrace = context.getCallStack().getBacktrace(node, 0, javaException);
        return ExceptionOperations.createRubyException(context, rubyClass, message, backtrace);
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyException createRubyException(RubyContext context, RubyClass rubyClass, Object message, Backtrace backtrace) {
        RubyLanguage language = context.getLanguageSlow();
        Object cause = ThreadNodes.ThreadGetExceptionNode.getLastException(language);
        context.getCoreExceptions().showExceptionIfDebug(rubyClass, message, backtrace);
        Shape shape = language.exceptionShape;
        return new RubyException(rubyClass, shape, message, backtrace, cause);
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyException createSystemStackError(RubyContext context, Object message, Backtrace backtrace, boolean showExceptionIfDebug) {
        RubyLanguage language = context.getLanguageSlow();
        RubyClass rubyClass = context.getCoreLibrary().systemStackErrorClass;
        Object cause = ThreadNodes.ThreadGetExceptionNode.getLastException(language);
        if (showExceptionIfDebug) {
            context.getCoreExceptions().showExceptionIfDebug(rubyClass, message, backtrace);
        }
        Shape shape = language.exceptionShape;
        return new RubyException(rubyClass, shape, message, backtrace, cause);
    }

    @CompilerDirectives.TruffleBoundary
    public static RubySystemCallError createSystemCallError(RubyContext context, RubyClass rubyClass, Object message, int errno, Backtrace backtrace) {
        RubyLanguage language = context.getLanguageSlow();
        Object cause = ThreadNodes.ThreadGetExceptionNode.getLastException(language);
        context.getCoreExceptions().showExceptionIfDebug(rubyClass, message, backtrace);
        Shape shape = language.systemCallErrorShape;
        return new RubySystemCallError(rubyClass, shape, message, backtrace, cause, errno);
    }

    public static RuntimeException rethrow(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw CompilerDirectives.shouldNotReachHere((String)"Checked Java Throwable rethrown", (Throwable)throwable);
    }

    public static enum ExceptionFormatter {
        SUPER_METHOD_ERROR("super: no superclass method `%s' for %s"),
        PROTECTED_METHOD_ERROR("protected method `%s' called for %s"),
        PRIVATE_METHOD_ERROR("private method `%s' called for %s"),
        NO_METHOD_ERROR("undefined method `%s' for %s"),
        NO_LOCAL_VARIABLE_OR_METHOD_ERROR("undefined local variable or method `%s' for %s");

        private final String fallbackFormat;

        private ExceptionFormatter(String fallbackFormat) {
            this.fallbackFormat = fallbackFormat;
        }

        @CompilerDirectives.TruffleBoundary
        public RubyProc getProc(RubyContext context) {
            RubyModule truffleExceptionOperations = context.getCoreLibrary().truffleExceptionOperationsModule;
            RubyConstant constant = truffleExceptionOperations.fields.getConstant(this.name());
            if (constant == null) {
                return null;
            }
            return (RubyProc)constant.getValue();
        }

        @CompilerDirectives.TruffleBoundary
        public String getMessage(RubyProc formatterProc, String methodName, Object receiver) {
            if (formatterProc != null) {
                return null;
            }
            return this.getFallbackMessage(methodName, receiver);
        }

        private String getFallbackMessage(String methodName, Object receiver) {
            return String.format(this.fallbackFormat, methodName, KernelNodes.ToSNode.uncachedBasicToS(receiver)) + " (could not find formatter " + this.name() + ")";
        }
    }
}

