/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.exception;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.exception.RubyFrozenError;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.objects.AllocationTracing;

@CoreModule(value="FrozenError", isClass=true)
public abstract class FrozenErrorNodes {

    @Primitive(name="frozen_error_set_receiver")
    public static abstract class ReceiverSetNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object setReceiver(RubyFrozenError error, Object receiver) {
            error.receiver = receiver;
            return receiver;
        }
    }

    @CoreMethod(names={"receiver"})
    public static abstract class ReceiverNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object receiver(RubyFrozenError self, @Cached InlinedBranchProfile errorProfile) {
            Object receiver = self.receiver;
            if (receiver == null) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentErrorNoReceiver(this));
            }
            return receiver;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyFrozenError allocateFrozenError(RubyClass rubyClass) {
            Shape shape = this.getLanguage().frozenErrorShape;
            RubyFrozenError instance = new RubyFrozenError(rubyClass, shape, nil, null, nil, null);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }
}

