/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format;

public abstract class LoopRecovery {
    private static final String DIRECTIVES = "CSLQcslqInjJNvVUwDdFfEeFfAaZBbHhuMmpPXx@";

    public static String recoverLoop(String format) {
        int index = 0;
        while (index < format.length()) {
            if (DIRECTIVES.indexOf(format.charAt(index)) == -1) {
                ++index;
                continue;
            }
            int successfulLengthOfLoopedString = -1;
            for (int tryLengthOfLoopedString = 1; tryLengthOfLoopedString <= index && index + tryLengthOfLoopedString <= format.length(); ++tryLengthOfLoopedString) {
                boolean charactersAfterRepetition;
                String beforeIndex = format.substring(index - tryLengthOfLoopedString, index);
                String afterIndex = format.substring(index, index + tryLengthOfLoopedString);
                boolean repetitionExists = beforeIndex.equals(afterIndex);
                boolean bl = charactersAfterRepetition = index + tryLengthOfLoopedString < format.length();
                if (!repetitionExists || charactersAfterRepetition && DIRECTIVES.indexOf(format.charAt(index + tryLengthOfLoopedString)) == -1) continue;
                successfulLengthOfLoopedString = tryLengthOfLoopedString;
            }
            if (successfulLengthOfLoopedString == -1) {
                ++index;
                continue;
            }
            String repeated = format.substring(index, index + successfulLengthOfLoopedString);
            int repetitionsCount = 2;
            int indexOfEndOfRepetitions = index + successfulLengthOfLoopedString;
            while (indexOfEndOfRepetitions + successfulLengthOfLoopedString <= format.length() && format.substring(indexOfEndOfRepetitions, indexOfEndOfRepetitions + successfulLengthOfLoopedString).equals(repeated) && (indexOfEndOfRepetitions + successfulLengthOfLoopedString >= format.length() || DIRECTIVES.indexOf(format.charAt(indexOfEndOfRepetitions + successfulLengthOfLoopedString)) != -1)) {
                ++repetitionsCount;
                indexOfEndOfRepetitions += successfulLengthOfLoopedString;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(format.substring(0, index - successfulLengthOfLoopedString));
            builder.append('(');
            builder.append(repeated);
            builder.append(')');
            builder.append(repetitionsCount);
            builder.append(format.substring(indexOfEndOfRepetitions));
            format = builder.toString();
        }
        return format;
    }
}

