/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.convert;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.memory.ByteArraySupport;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.MissingValue;
import org.truffleruby.language.Nil;

@NodeChild(value="bytes")
public abstract class BytesToInteger16LittleNode
extends FormatNode {
    private final boolean signed;

    protected BytesToInteger16LittleNode(boolean signed) {
        this.signed = signed;
    }

    @Specialization
    MissingValue decode(MissingValue missingValue) {
        return missingValue;
    }

    @Specialization
    Object decode(Nil nil) {
        return nil;
    }

    @Specialization
    int decode(byte[] bytes) {
        short value = ByteArraySupport.littleEndian().getShort(bytes, 0);
        if (this.signed) {
            return value;
        }
        return Short.toUnsignedInt(value);
    }
}

