/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.convert;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.exceptions.NoImplicitConversionException;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;

@NodeChild(value="value")
public abstract class ToStrNode
extends FormatNode {
    public abstract Object execute(Object var1);

    @Specialization
    RubyString coerceRubyString(RubyString string) {
        return string;
    }

    @Specialization
    ImmutableRubyString coerceImmutableRubyString(ImmutableRubyString string) {
        return string;
    }

    @Specialization(guards={"isNotRubyString(object)"})
    Object coerceObject(Object object, @Cached InlinedBranchProfile errorProfile, @Cached DispatchNode toStrNode, @Cached RubyStringLibrary libString) {
        Object coerced;
        try {
            coerced = toStrNode.call(object, "to_str");
        }
        catch (RaiseException e) {
            errorProfile.enter((Node)this);
            if (e.getException().getLogicalClass() == this.coreLibrary().noMethodErrorClass) {
                throw new NoImplicitConversionException(object, "String");
            }
            throw e;
        }
        if (libString.isRubyString(coerced)) {
            return coerced;
        }
        errorProfile.enter((Node)this);
        throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorBadCoercion(object, "String", "to_str", coerced, this));
    }
}

